/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CatalogInfoResponseLimits;
import com.squareup.square.models.Error;
import com.squareup.square.models.StandardUnitDescriptionGroup;
import java.util.List;
import java.util.Objects;

public class CatalogInfoResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final CatalogInfoResponseLimits limits;
    private final StandardUnitDescriptionGroup standardUnitDescriptionGroup;

    @JsonCreator
    public CatalogInfoResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="limits") CatalogInfoResponseLimits limits, @JsonProperty(value="standard_unit_description_group") StandardUnitDescriptionGroup standardUnitDescriptionGroup) {
        this.errors = errors;
        this.limits = limits;
        this.standardUnitDescriptionGroup = standardUnitDescriptionGroup;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="limits")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogInfoResponseLimits getLimits() {
        return this.limits;
    }

    @JsonGetter(value="standard_unit_description_group")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public StandardUnitDescriptionGroup getStandardUnitDescriptionGroup() {
        return this.standardUnitDescriptionGroup;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.limits, this.standardUnitDescriptionGroup);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogInfoResponse)) {
            return false;
        }
        CatalogInfoResponse other = (CatalogInfoResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.limits, other.limits) && Objects.equals(this.standardUnitDescriptionGroup, other.standardUnitDescriptionGroup);
    }

    public String toString() {
        return "CatalogInfoResponse [errors=" + this.errors + ", limits=" + this.limits + ", standardUnitDescriptionGroup=" + this.standardUnitDescriptionGroup + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).limits(this.getLimits()).standardUnitDescriptionGroup(this.getStandardUnitDescriptionGroup());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private CatalogInfoResponseLimits limits;
        private StandardUnitDescriptionGroup standardUnitDescriptionGroup;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder limits(CatalogInfoResponseLimits limits) {
            this.limits = limits;
            return this;
        }

        public Builder standardUnitDescriptionGroup(StandardUnitDescriptionGroup standardUnitDescriptionGroup) {
            this.standardUnitDescriptionGroup = standardUnitDescriptionGroup;
            return this;
        }

        public CatalogInfoResponse build() {
            CatalogInfoResponse model = new CatalogInfoResponse(this.errors, this.limits, this.standardUnitDescriptionGroup);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

