/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogItemModifierListInfo;
import com.squareup.square.models.CatalogItemOptionForItem;
import com.squareup.square.models.CatalogObject;
import java.util.List;
import java.util.Objects;

public class CatalogItem {
    private final String name;
    private final String description;
    private final String abbreviation;
    private final String labelColor;
    private final Boolean availableOnline;
    private final Boolean availableForPickup;
    private final Boolean availableElectronically;
    private final String categoryId;
    private final List<String> taxIds;
    private final List<CatalogItemModifierListInfo> modifierListInfo;
    private final List<CatalogObject> variations;
    private final String productType;
    private final Boolean skipModifierScreen;
    private final List<CatalogItemOptionForItem> itemOptions;
    private final List<String> imageIds;
    private final String sortName;

    @JsonCreator
    public CatalogItem(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="abbreviation") String abbreviation, @JsonProperty(value="label_color") String labelColor, @JsonProperty(value="available_online") Boolean availableOnline, @JsonProperty(value="available_for_pickup") Boolean availableForPickup, @JsonProperty(value="available_electronically") Boolean availableElectronically, @JsonProperty(value="category_id") String categoryId, @JsonProperty(value="tax_ids") List<String> taxIds, @JsonProperty(value="modifier_list_info") List<CatalogItemModifierListInfo> modifierListInfo, @JsonProperty(value="variations") List<CatalogObject> variations, @JsonProperty(value="product_type") String productType, @JsonProperty(value="skip_modifier_screen") Boolean skipModifierScreen, @JsonProperty(value="item_options") List<CatalogItemOptionForItem> itemOptions, @JsonProperty(value="image_ids") List<String> imageIds, @JsonProperty(value="sort_name") String sortName) {
        this.name = name;
        this.description = description;
        this.abbreviation = abbreviation;
        this.labelColor = labelColor;
        this.availableOnline = availableOnline;
        this.availableForPickup = availableForPickup;
        this.availableElectronically = availableElectronically;
        this.categoryId = categoryId;
        this.taxIds = taxIds;
        this.modifierListInfo = modifierListInfo;
        this.variations = variations;
        this.productType = productType;
        this.skipModifierScreen = skipModifierScreen;
        this.itemOptions = itemOptions;
        this.imageIds = imageIds;
        this.sortName = sortName;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="abbreviation")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @JsonGetter(value="label_color")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLabelColor() {
        return this.labelColor;
    }

    @JsonGetter(value="available_online")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAvailableOnline() {
        return this.availableOnline;
    }

    @JsonGetter(value="available_for_pickup")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAvailableForPickup() {
        return this.availableForPickup;
    }

    @JsonGetter(value="available_electronically")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAvailableElectronically() {
        return this.availableElectronically;
    }

    @JsonGetter(value="category_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCategoryId() {
        return this.categoryId;
    }

    @JsonGetter(value="tax_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getTaxIds() {
        return this.taxIds;
    }

    @JsonGetter(value="modifier_list_info")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogItemModifierListInfo> getModifierListInfo() {
        return this.modifierListInfo;
    }

    @JsonGetter(value="variations")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogObject> getVariations() {
        return this.variations;
    }

    @JsonGetter(value="product_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getProductType() {
        return this.productType;
    }

    @JsonGetter(value="skip_modifier_screen")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getSkipModifierScreen() {
        return this.skipModifierScreen;
    }

    @JsonGetter(value="item_options")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogItemOptionForItem> getItemOptions() {
        return this.itemOptions;
    }

    @JsonGetter(value="image_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getImageIds() {
        return this.imageIds;
    }

    @JsonGetter(value="sort_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortName() {
        return this.sortName;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.abbreviation, this.labelColor, this.availableOnline, this.availableForPickup, this.availableElectronically, this.categoryId, this.taxIds, this.modifierListInfo, this.variations, this.productType, this.skipModifierScreen, this.itemOptions, this.imageIds, this.sortName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogItem)) {
            return false;
        }
        CatalogItem other = (CatalogItem)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.abbreviation, other.abbreviation) && Objects.equals(this.labelColor, other.labelColor) && Objects.equals(this.availableOnline, other.availableOnline) && Objects.equals(this.availableForPickup, other.availableForPickup) && Objects.equals(this.availableElectronically, other.availableElectronically) && Objects.equals(this.categoryId, other.categoryId) && Objects.equals(this.taxIds, other.taxIds) && Objects.equals(this.modifierListInfo, other.modifierListInfo) && Objects.equals(this.variations, other.variations) && Objects.equals(this.productType, other.productType) && Objects.equals(this.skipModifierScreen, other.skipModifierScreen) && Objects.equals(this.itemOptions, other.itemOptions) && Objects.equals(this.imageIds, other.imageIds) && Objects.equals(this.sortName, other.sortName);
    }

    public String toString() {
        return "CatalogItem [name=" + this.name + ", description=" + this.description + ", abbreviation=" + this.abbreviation + ", labelColor=" + this.labelColor + ", availableOnline=" + this.availableOnline + ", availableForPickup=" + this.availableForPickup + ", availableElectronically=" + this.availableElectronically + ", categoryId=" + this.categoryId + ", taxIds=" + this.taxIds + ", modifierListInfo=" + this.modifierListInfo + ", variations=" + this.variations + ", productType=" + this.productType + ", skipModifierScreen=" + this.skipModifierScreen + ", itemOptions=" + this.itemOptions + ", imageIds=" + this.imageIds + ", sortName=" + this.sortName + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).description(this.getDescription()).abbreviation(this.getAbbreviation()).labelColor(this.getLabelColor()).availableOnline(this.getAvailableOnline()).availableForPickup(this.getAvailableForPickup()).availableElectronically(this.getAvailableElectronically()).categoryId(this.getCategoryId()).taxIds(this.getTaxIds()).modifierListInfo(this.getModifierListInfo()).variations(this.getVariations()).productType(this.getProductType()).skipModifierScreen(this.getSkipModifierScreen()).itemOptions(this.getItemOptions()).imageIds(this.getImageIds()).sortName(this.getSortName());
        return builder;
    }

    public static class Builder {
        private String name;
        private String description;
        private String abbreviation;
        private String labelColor;
        private Boolean availableOnline;
        private Boolean availableForPickup;
        private Boolean availableElectronically;
        private String categoryId;
        private List<String> taxIds;
        private List<CatalogItemModifierListInfo> modifierListInfo;
        private List<CatalogObject> variations;
        private String productType;
        private Boolean skipModifierScreen;
        private List<CatalogItemOptionForItem> itemOptions;
        private List<String> imageIds;
        private String sortName;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder abbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
            return this;
        }

        public Builder labelColor(String labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public Builder availableOnline(Boolean availableOnline) {
            this.availableOnline = availableOnline;
            return this;
        }

        public Builder availableForPickup(Boolean availableForPickup) {
            this.availableForPickup = availableForPickup;
            return this;
        }

        public Builder availableElectronically(Boolean availableElectronically) {
            this.availableElectronically = availableElectronically;
            return this;
        }

        public Builder categoryId(String categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public Builder taxIds(List<String> taxIds) {
            this.taxIds = taxIds;
            return this;
        }

        public Builder modifierListInfo(List<CatalogItemModifierListInfo> modifierListInfo) {
            this.modifierListInfo = modifierListInfo;
            return this;
        }

        public Builder variations(List<CatalogObject> variations) {
            this.variations = variations;
            return this;
        }

        public Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        public Builder skipModifierScreen(Boolean skipModifierScreen) {
            this.skipModifierScreen = skipModifierScreen;
            return this;
        }

        public Builder itemOptions(List<CatalogItemOptionForItem> itemOptions) {
            this.itemOptions = itemOptions;
            return this;
        }

        public Builder imageIds(List<String> imageIds) {
            this.imageIds = imageIds;
            return this;
        }

        public Builder sortName(String sortName) {
            this.sortName = sortName;
            return this;
        }

        public CatalogItem build() {
            return new CatalogItem(this.name, this.description, this.abbreviation, this.labelColor, this.availableOnline, this.availableForPickup, this.availableElectronically, this.categoryId, this.taxIds, this.modifierListInfo, this.variations, this.productType, this.skipModifierScreen, this.itemOptions, this.imageIds, this.sortName);
        }
    }
}

