/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogModifierOverride;
import java.util.List;
import java.util.Objects;

public class CatalogItemModifierListInfo {
    private final String modifierListId;
    private final List<CatalogModifierOverride> modifierOverrides;
    private final Integer minSelectedModifiers;
    private final Integer maxSelectedModifiers;
    private final Boolean enabled;

    @JsonCreator
    public CatalogItemModifierListInfo(@JsonProperty(value="modifier_list_id") String modifierListId, @JsonProperty(value="modifier_overrides") List<CatalogModifierOverride> modifierOverrides, @JsonProperty(value="min_selected_modifiers") Integer minSelectedModifiers, @JsonProperty(value="max_selected_modifiers") Integer maxSelectedModifiers, @JsonProperty(value="enabled") Boolean enabled) {
        this.modifierListId = modifierListId;
        this.modifierOverrides = modifierOverrides;
        this.minSelectedModifiers = minSelectedModifiers;
        this.maxSelectedModifiers = maxSelectedModifiers;
        this.enabled = enabled;
    }

    @JsonGetter(value="modifier_list_id")
    public String getModifierListId() {
        return this.modifierListId;
    }

    @JsonGetter(value="modifier_overrides")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogModifierOverride> getModifierOverrides() {
        return this.modifierOverrides;
    }

    @JsonGetter(value="min_selected_modifiers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMinSelectedModifiers() {
        return this.minSelectedModifiers;
    }

    @JsonGetter(value="max_selected_modifiers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaxSelectedModifiers() {
        return this.maxSelectedModifiers;
    }

    @JsonGetter(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getEnabled() {
        return this.enabled;
    }

    public int hashCode() {
        return Objects.hash(this.modifierListId, this.modifierOverrides, this.minSelectedModifiers, this.maxSelectedModifiers, this.enabled);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogItemModifierListInfo)) {
            return false;
        }
        CatalogItemModifierListInfo other = (CatalogItemModifierListInfo)obj;
        return Objects.equals(this.modifierListId, other.modifierListId) && Objects.equals(this.modifierOverrides, other.modifierOverrides) && Objects.equals(this.minSelectedModifiers, other.minSelectedModifiers) && Objects.equals(this.maxSelectedModifiers, other.maxSelectedModifiers) && Objects.equals(this.enabled, other.enabled);
    }

    public String toString() {
        return "CatalogItemModifierListInfo [modifierListId=" + this.modifierListId + ", modifierOverrides=" + this.modifierOverrides + ", minSelectedModifiers=" + this.minSelectedModifiers + ", maxSelectedModifiers=" + this.maxSelectedModifiers + ", enabled=" + this.enabled + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.modifierListId).modifierOverrides(this.getModifierOverrides()).minSelectedModifiers(this.getMinSelectedModifiers()).maxSelectedModifiers(this.getMaxSelectedModifiers()).enabled(this.getEnabled());
        return builder;
    }

    public static class Builder {
        private String modifierListId;
        private List<CatalogModifierOverride> modifierOverrides;
        private Integer minSelectedModifiers;
        private Integer maxSelectedModifiers;
        private Boolean enabled;

        public Builder(String modifierListId) {
            this.modifierListId = modifierListId;
        }

        public Builder modifierListId(String modifierListId) {
            this.modifierListId = modifierListId;
            return this;
        }

        public Builder modifierOverrides(List<CatalogModifierOverride> modifierOverrides) {
            this.modifierOverrides = modifierOverrides;
            return this;
        }

        public Builder minSelectedModifiers(Integer minSelectedModifiers) {
            this.minSelectedModifiers = minSelectedModifiers;
            return this;
        }

        public Builder maxSelectedModifiers(Integer maxSelectedModifiers) {
            this.maxSelectedModifiers = maxSelectedModifiers;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public CatalogItemModifierListInfo build() {
            return new CatalogItemModifierListInfo(this.modifierListId, this.modifierOverrides, this.minSelectedModifiers, this.maxSelectedModifiers, this.enabled);
        }
    }
}

