/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogObject;
import java.util.List;
import java.util.Objects;

public class CatalogItemOption {
    private final String name;
    private final String displayName;
    private final String description;
    private final Boolean showColors;
    private final List<CatalogObject> values;

    @JsonCreator
    public CatalogItemOption(@JsonProperty(value="name") String name, @JsonProperty(value="display_name") String displayName, @JsonProperty(value="description") String description, @JsonProperty(value="show_colors") Boolean showColors, @JsonProperty(value="values") List<CatalogObject> values) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.showColors = showColors;
        this.values = values;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="display_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="show_colors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getShowColors() {
        return this.showColors;
    }

    @JsonGetter(value="values")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogObject> getValues() {
        return this.values;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.displayName, this.description, this.showColors, this.values);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogItemOption)) {
            return false;
        }
        CatalogItemOption other = (CatalogItemOption)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.showColors, other.showColors) && Objects.equals(this.values, other.values);
    }

    public String toString() {
        return "CatalogItemOption [name=" + this.name + ", displayName=" + this.displayName + ", description=" + this.description + ", showColors=" + this.showColors + ", values=" + this.values + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).displayName(this.getDisplayName()).description(this.getDescription()).showColors(this.getShowColors()).values(this.getValues());
        return builder;
    }

    public static class Builder {
        private String name;
        private String displayName;
        private String description;
        private Boolean showColors;
        private List<CatalogObject> values;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder showColors(Boolean showColors) {
            this.showColors = showColors;
            return this;
        }

        public Builder values(List<CatalogObject> values) {
            this.values = values;
            return this;
        }

        public CatalogItemOption build() {
            return new CatalogItemOption(this.name, this.displayName, this.description, this.showColors, this.values);
        }
    }
}

