/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CatalogItemOptionValue {
    private final String itemOptionId;
    private final String name;
    private final String description;
    private final String color;
    private final Integer ordinal;

    @JsonCreator
    public CatalogItemOptionValue(@JsonProperty(value="item_option_id") String itemOptionId, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="color") String color, @JsonProperty(value="ordinal") Integer ordinal) {
        this.itemOptionId = itemOptionId;
        this.name = name;
        this.description = description;
        this.color = color;
        this.ordinal = ordinal;
    }

    @JsonGetter(value="item_option_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getItemOptionId() {
        return this.itemOptionId;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="color")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getColor() {
        return this.color;
    }

    @JsonGetter(value="ordinal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getOrdinal() {
        return this.ordinal;
    }

    public int hashCode() {
        return Objects.hash(this.itemOptionId, this.name, this.description, this.color, this.ordinal);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogItemOptionValue)) {
            return false;
        }
        CatalogItemOptionValue other = (CatalogItemOptionValue)obj;
        return Objects.equals(this.itemOptionId, other.itemOptionId) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.color, other.color) && Objects.equals(this.ordinal, other.ordinal);
    }

    public String toString() {
        return "CatalogItemOptionValue [itemOptionId=" + this.itemOptionId + ", name=" + this.name + ", description=" + this.description + ", color=" + this.color + ", ordinal=" + this.ordinal + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().itemOptionId(this.getItemOptionId()).name(this.getName()).description(this.getDescription()).color(this.getColor()).ordinal(this.getOrdinal());
        return builder;
    }

    public static class Builder {
        private String itemOptionId;
        private String name;
        private String description;
        private String color;
        private Integer ordinal;

        public Builder itemOptionId(String itemOptionId) {
            this.itemOptionId = itemOptionId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            return this;
        }

        public Builder ordinal(Integer ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public CatalogItemOptionValue build() {
            return new CatalogItemOptionValue(this.itemOptionId, this.name, this.description, this.color, this.ordinal);
        }
    }
}

