/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogItemOptionValueForItemVariation;
import com.squareup.square.models.CatalogStockConversion;
import com.squareup.square.models.ItemVariationLocationOverrides;
import com.squareup.square.models.Money;
import java.util.List;
import java.util.Objects;

public class CatalogItemVariation {
    private final String itemId;
    private final String name;
    private final String sku;
    private final String upc;
    private final Integer ordinal;
    private final String pricingType;
    private final Money priceMoney;
    private final List<ItemVariationLocationOverrides> locationOverrides;
    private final Boolean trackInventory;
    private final String inventoryAlertType;
    private final Long inventoryAlertThreshold;
    private final String userData;
    private final Long serviceDuration;
    private final Boolean availableForBooking;
    private final List<CatalogItemOptionValueForItemVariation> itemOptionValues;
    private final String measurementUnitId;
    private final Boolean sellable;
    private final Boolean stockable;
    private final List<String> imageIds;
    private final List<String> teamMemberIds;
    private final CatalogStockConversion stockableConversion;

    @JsonCreator
    public CatalogItemVariation(@JsonProperty(value="item_id") String itemId, @JsonProperty(value="name") String name, @JsonProperty(value="sku") String sku, @JsonProperty(value="upc") String upc, @JsonProperty(value="ordinal") Integer ordinal, @JsonProperty(value="pricing_type") String pricingType, @JsonProperty(value="price_money") Money priceMoney, @JsonProperty(value="location_overrides") List<ItemVariationLocationOverrides> locationOverrides, @JsonProperty(value="track_inventory") Boolean trackInventory, @JsonProperty(value="inventory_alert_type") String inventoryAlertType, @JsonProperty(value="inventory_alert_threshold") Long inventoryAlertThreshold, @JsonProperty(value="user_data") String userData, @JsonProperty(value="service_duration") Long serviceDuration, @JsonProperty(value="available_for_booking") Boolean availableForBooking, @JsonProperty(value="item_option_values") List<CatalogItemOptionValueForItemVariation> itemOptionValues, @JsonProperty(value="measurement_unit_id") String measurementUnitId, @JsonProperty(value="sellable") Boolean sellable, @JsonProperty(value="stockable") Boolean stockable, @JsonProperty(value="image_ids") List<String> imageIds, @JsonProperty(value="team_member_ids") List<String> teamMemberIds, @JsonProperty(value="stockable_conversion") CatalogStockConversion stockableConversion) {
        this.itemId = itemId;
        this.name = name;
        this.sku = sku;
        this.upc = upc;
        this.ordinal = ordinal;
        this.pricingType = pricingType;
        this.priceMoney = priceMoney;
        this.locationOverrides = locationOverrides;
        this.trackInventory = trackInventory;
        this.inventoryAlertType = inventoryAlertType;
        this.inventoryAlertThreshold = inventoryAlertThreshold;
        this.userData = userData;
        this.serviceDuration = serviceDuration;
        this.availableForBooking = availableForBooking;
        this.itemOptionValues = itemOptionValues;
        this.measurementUnitId = measurementUnitId;
        this.sellable = sellable;
        this.stockable = stockable;
        this.imageIds = imageIds;
        this.teamMemberIds = teamMemberIds;
        this.stockableConversion = stockableConversion;
    }

    @JsonGetter(value="item_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getItemId() {
        return this.itemId;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="sku")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSku() {
        return this.sku;
    }

    @JsonGetter(value="upc")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpc() {
        return this.upc;
    }

    @JsonGetter(value="ordinal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getOrdinal() {
        return this.ordinal;
    }

    @JsonGetter(value="pricing_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPricingType() {
        return this.pricingType;
    }

    @JsonGetter(value="price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPriceMoney() {
        return this.priceMoney;
    }

    @JsonGetter(value="location_overrides")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ItemVariationLocationOverrides> getLocationOverrides() {
        return this.locationOverrides;
    }

    @JsonGetter(value="track_inventory")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getTrackInventory() {
        return this.trackInventory;
    }

    @JsonGetter(value="inventory_alert_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInventoryAlertType() {
        return this.inventoryAlertType;
    }

    @JsonGetter(value="inventory_alert_threshold")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getInventoryAlertThreshold() {
        return this.inventoryAlertThreshold;
    }

    @JsonGetter(value="user_data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUserData() {
        return this.userData;
    }

    @JsonGetter(value="service_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getServiceDuration() {
        return this.serviceDuration;
    }

    @JsonGetter(value="available_for_booking")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAvailableForBooking() {
        return this.availableForBooking;
    }

    @JsonGetter(value="item_option_values")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogItemOptionValueForItemVariation> getItemOptionValues() {
        return this.itemOptionValues;
    }

    @JsonGetter(value="measurement_unit_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMeasurementUnitId() {
        return this.measurementUnitId;
    }

    @JsonGetter(value="sellable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getSellable() {
        return this.sellable;
    }

    @JsonGetter(value="stockable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getStockable() {
        return this.stockable;
    }

    @JsonGetter(value="image_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getImageIds() {
        return this.imageIds;
    }

    @JsonGetter(value="team_member_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getTeamMemberIds() {
        return this.teamMemberIds;
    }

    @JsonGetter(value="stockable_conversion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogStockConversion getStockableConversion() {
        return this.stockableConversion;
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.name, this.sku, this.upc, this.ordinal, this.pricingType, this.priceMoney, this.locationOverrides, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold, this.userData, this.serviceDuration, this.availableForBooking, this.itemOptionValues, this.measurementUnitId, this.sellable, this.stockable, this.imageIds, this.teamMemberIds, this.stockableConversion);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogItemVariation)) {
            return false;
        }
        CatalogItemVariation other = (CatalogItemVariation)obj;
        return Objects.equals(this.itemId, other.itemId) && Objects.equals(this.name, other.name) && Objects.equals(this.sku, other.sku) && Objects.equals(this.upc, other.upc) && Objects.equals(this.ordinal, other.ordinal) && Objects.equals(this.pricingType, other.pricingType) && Objects.equals(this.priceMoney, other.priceMoney) && Objects.equals(this.locationOverrides, other.locationOverrides) && Objects.equals(this.trackInventory, other.trackInventory) && Objects.equals(this.inventoryAlertType, other.inventoryAlertType) && Objects.equals(this.inventoryAlertThreshold, other.inventoryAlertThreshold) && Objects.equals(this.userData, other.userData) && Objects.equals(this.serviceDuration, other.serviceDuration) && Objects.equals(this.availableForBooking, other.availableForBooking) && Objects.equals(this.itemOptionValues, other.itemOptionValues) && Objects.equals(this.measurementUnitId, other.measurementUnitId) && Objects.equals(this.sellable, other.sellable) && Objects.equals(this.stockable, other.stockable) && Objects.equals(this.imageIds, other.imageIds) && Objects.equals(this.teamMemberIds, other.teamMemberIds) && Objects.equals(this.stockableConversion, other.stockableConversion);
    }

    public String toString() {
        return "CatalogItemVariation [itemId=" + this.itemId + ", name=" + this.name + ", sku=" + this.sku + ", upc=" + this.upc + ", ordinal=" + this.ordinal + ", pricingType=" + this.pricingType + ", priceMoney=" + this.priceMoney + ", locationOverrides=" + this.locationOverrides + ", trackInventory=" + this.trackInventory + ", inventoryAlertType=" + this.inventoryAlertType + ", inventoryAlertThreshold=" + this.inventoryAlertThreshold + ", userData=" + this.userData + ", serviceDuration=" + this.serviceDuration + ", availableForBooking=" + this.availableForBooking + ", itemOptionValues=" + this.itemOptionValues + ", measurementUnitId=" + this.measurementUnitId + ", sellable=" + this.sellable + ", stockable=" + this.stockable + ", imageIds=" + this.imageIds + ", teamMemberIds=" + this.teamMemberIds + ", stockableConversion=" + this.stockableConversion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().itemId(this.getItemId()).name(this.getName()).sku(this.getSku()).upc(this.getUpc()).ordinal(this.getOrdinal()).pricingType(this.getPricingType()).priceMoney(this.getPriceMoney()).locationOverrides(this.getLocationOverrides()).trackInventory(this.getTrackInventory()).inventoryAlertType(this.getInventoryAlertType()).inventoryAlertThreshold(this.getInventoryAlertThreshold()).userData(this.getUserData()).serviceDuration(this.getServiceDuration()).availableForBooking(this.getAvailableForBooking()).itemOptionValues(this.getItemOptionValues()).measurementUnitId(this.getMeasurementUnitId()).sellable(this.getSellable()).stockable(this.getStockable()).imageIds(this.getImageIds()).teamMemberIds(this.getTeamMemberIds()).stockableConversion(this.getStockableConversion());
        return builder;
    }

    public static class Builder {
        private String itemId;
        private String name;
        private String sku;
        private String upc;
        private Integer ordinal;
        private String pricingType;
        private Money priceMoney;
        private List<ItemVariationLocationOverrides> locationOverrides;
        private Boolean trackInventory;
        private String inventoryAlertType;
        private Long inventoryAlertThreshold;
        private String userData;
        private Long serviceDuration;
        private Boolean availableForBooking;
        private List<CatalogItemOptionValueForItemVariation> itemOptionValues;
        private String measurementUnitId;
        private Boolean sellable;
        private Boolean stockable;
        private List<String> imageIds;
        private List<String> teamMemberIds;
        private CatalogStockConversion stockableConversion;

        public Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public Builder upc(String upc) {
            this.upc = upc;
            return this;
        }

        public Builder ordinal(Integer ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder pricingType(String pricingType) {
            this.pricingType = pricingType;
            return this;
        }

        public Builder priceMoney(Money priceMoney) {
            this.priceMoney = priceMoney;
            return this;
        }

        public Builder locationOverrides(List<ItemVariationLocationOverrides> locationOverrides) {
            this.locationOverrides = locationOverrides;
            return this;
        }

        public Builder trackInventory(Boolean trackInventory) {
            this.trackInventory = trackInventory;
            return this;
        }

        public Builder inventoryAlertType(String inventoryAlertType) {
            this.inventoryAlertType = inventoryAlertType;
            return this;
        }

        public Builder inventoryAlertThreshold(Long inventoryAlertThreshold) {
            this.inventoryAlertThreshold = inventoryAlertThreshold;
            return this;
        }

        public Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public Builder serviceDuration(Long serviceDuration) {
            this.serviceDuration = serviceDuration;
            return this;
        }

        public Builder availableForBooking(Boolean availableForBooking) {
            this.availableForBooking = availableForBooking;
            return this;
        }

        public Builder itemOptionValues(List<CatalogItemOptionValueForItemVariation> itemOptionValues) {
            this.itemOptionValues = itemOptionValues;
            return this;
        }

        public Builder measurementUnitId(String measurementUnitId) {
            this.measurementUnitId = measurementUnitId;
            return this;
        }

        public Builder sellable(Boolean sellable) {
            this.sellable = sellable;
            return this;
        }

        public Builder stockable(Boolean stockable) {
            this.stockable = stockable;
            return this;
        }

        public Builder imageIds(List<String> imageIds) {
            this.imageIds = imageIds;
            return this;
        }

        public Builder teamMemberIds(List<String> teamMemberIds) {
            this.teamMemberIds = teamMemberIds;
            return this;
        }

        public Builder stockableConversion(CatalogStockConversion stockableConversion) {
            this.stockableConversion = stockableConversion;
            return this;
        }

        public CatalogItemVariation build() {
            return new CatalogItemVariation(this.itemId, this.name, this.sku, this.upc, this.ordinal, this.pricingType, this.priceMoney, this.locationOverrides, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold, this.userData, this.serviceDuration, this.availableForBooking, this.itemOptionValues, this.measurementUnitId, this.sellable, this.stockable, this.imageIds, this.teamMemberIds, this.stockableConversion);
        }
    }
}

