/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.MeasurementUnit;
import java.util.Objects;

public class CatalogMeasurementUnit {
    private final MeasurementUnit measurementUnit;
    private final Integer precision;

    @JsonCreator
    public CatalogMeasurementUnit(@JsonProperty(value="measurement_unit") MeasurementUnit measurementUnit, @JsonProperty(value="precision") Integer precision) {
        this.measurementUnit = measurementUnit;
        this.precision = precision;
    }

    @JsonGetter(value="measurement_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    @JsonGetter(value="precision")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getPrecision() {
        return this.precision;
    }

    public int hashCode() {
        return Objects.hash(this.measurementUnit, this.precision);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogMeasurementUnit)) {
            return false;
        }
        CatalogMeasurementUnit other = (CatalogMeasurementUnit)obj;
        return Objects.equals(this.measurementUnit, other.measurementUnit) && Objects.equals(this.precision, other.precision);
    }

    public String toString() {
        return "CatalogMeasurementUnit [measurementUnit=" + this.measurementUnit + ", precision=" + this.precision + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().measurementUnit(this.getMeasurementUnit()).precision(this.getPrecision());
        return builder;
    }

    public static class Builder {
        private MeasurementUnit measurementUnit;
        private Integer precision;

        public Builder measurementUnit(MeasurementUnit measurementUnit) {
            this.measurementUnit = measurementUnit;
            return this;
        }

        public Builder precision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public CatalogMeasurementUnit build() {
            return new CatalogMeasurementUnit(this.measurementUnit, this.precision);
        }
    }
}

