/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.List;
import java.util.Objects;

public class CatalogModifier {
    private final String name;
    private final Money priceMoney;
    private final Integer ordinal;
    private final String modifierListId;
    private final List<String> imageIds;

    @JsonCreator
    public CatalogModifier(@JsonProperty(value="name") String name, @JsonProperty(value="price_money") Money priceMoney, @JsonProperty(value="ordinal") Integer ordinal, @JsonProperty(value="modifier_list_id") String modifierListId, @JsonProperty(value="image_ids") List<String> imageIds) {
        this.name = name;
        this.priceMoney = priceMoney;
        this.ordinal = ordinal;
        this.modifierListId = modifierListId;
        this.imageIds = imageIds;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPriceMoney() {
        return this.priceMoney;
    }

    @JsonGetter(value="ordinal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getOrdinal() {
        return this.ordinal;
    }

    @JsonGetter(value="modifier_list_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getModifierListId() {
        return this.modifierListId;
    }

    @JsonGetter(value="image_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getImageIds() {
        return this.imageIds;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.priceMoney, this.ordinal, this.modifierListId, this.imageIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogModifier)) {
            return false;
        }
        CatalogModifier other = (CatalogModifier)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.priceMoney, other.priceMoney) && Objects.equals(this.ordinal, other.ordinal) && Objects.equals(this.modifierListId, other.modifierListId) && Objects.equals(this.imageIds, other.imageIds);
    }

    public String toString() {
        return "CatalogModifier [name=" + this.name + ", priceMoney=" + this.priceMoney + ", ordinal=" + this.ordinal + ", modifierListId=" + this.modifierListId + ", imageIds=" + this.imageIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).priceMoney(this.getPriceMoney()).ordinal(this.getOrdinal()).modifierListId(this.getModifierListId()).imageIds(this.getImageIds());
        return builder;
    }

    public static class Builder {
        private String name;
        private Money priceMoney;
        private Integer ordinal;
        private String modifierListId;
        private List<String> imageIds;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder priceMoney(Money priceMoney) {
            this.priceMoney = priceMoney;
            return this;
        }

        public Builder ordinal(Integer ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder modifierListId(String modifierListId) {
            this.modifierListId = modifierListId;
            return this;
        }

        public Builder imageIds(List<String> imageIds) {
            this.imageIds = imageIds;
            return this;
        }

        public CatalogModifier build() {
            return new CatalogModifier(this.name, this.priceMoney, this.ordinal, this.modifierListId, this.imageIds);
        }
    }
}

