/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogObject;
import java.util.List;
import java.util.Objects;

public class CatalogModifierList {
    private final String name;
    private final Integer ordinal;
    private final String selectionType;
    private final List<CatalogObject> modifiers;
    private final List<String> imageIds;

    @JsonCreator
    public CatalogModifierList(@JsonProperty(value="name") String name, @JsonProperty(value="ordinal") Integer ordinal, @JsonProperty(value="selection_type") String selectionType, @JsonProperty(value="modifiers") List<CatalogObject> modifiers, @JsonProperty(value="image_ids") List<String> imageIds) {
        this.name = name;
        this.ordinal = ordinal;
        this.selectionType = selectionType;
        this.modifiers = modifiers;
        this.imageIds = imageIds;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="ordinal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getOrdinal() {
        return this.ordinal;
    }

    @JsonGetter(value="selection_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSelectionType() {
        return this.selectionType;
    }

    @JsonGetter(value="modifiers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogObject> getModifiers() {
        return this.modifiers;
    }

    @JsonGetter(value="image_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getImageIds() {
        return this.imageIds;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ordinal, this.selectionType, this.modifiers, this.imageIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogModifierList)) {
            return false;
        }
        CatalogModifierList other = (CatalogModifierList)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.ordinal, other.ordinal) && Objects.equals(this.selectionType, other.selectionType) && Objects.equals(this.modifiers, other.modifiers) && Objects.equals(this.imageIds, other.imageIds);
    }

    public String toString() {
        return "CatalogModifierList [name=" + this.name + ", ordinal=" + this.ordinal + ", selectionType=" + this.selectionType + ", modifiers=" + this.modifiers + ", imageIds=" + this.imageIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).ordinal(this.getOrdinal()).selectionType(this.getSelectionType()).modifiers(this.getModifiers()).imageIds(this.getImageIds());
        return builder;
    }

    public static class Builder {
        private String name;
        private Integer ordinal;
        private String selectionType;
        private List<CatalogObject> modifiers;
        private List<String> imageIds;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder ordinal(Integer ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder selectionType(String selectionType) {
            this.selectionType = selectionType;
            return this;
        }

        public Builder modifiers(List<CatalogObject> modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public Builder imageIds(List<String> imageIds) {
            this.imageIds = imageIds;
            return this;
        }

        public CatalogModifierList build() {
            return new CatalogModifierList(this.name, this.ordinal, this.selectionType, this.modifiers, this.imageIds);
        }
    }
}

