/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CatalogObjectReference {
    private final String objectId;
    private final Long catalogVersion;

    @JsonCreator
    public CatalogObjectReference(@JsonProperty(value="object_id") String objectId, @JsonProperty(value="catalog_version") Long catalogVersion) {
        this.objectId = objectId;
        this.catalogVersion = catalogVersion;
    }

    @JsonGetter(value="object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getObjectId() {
        return this.objectId;
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getCatalogVersion() {
        return this.catalogVersion;
    }

    public int hashCode() {
        return Objects.hash(this.objectId, this.catalogVersion);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogObjectReference)) {
            return false;
        }
        CatalogObjectReference other = (CatalogObjectReference)obj;
        return Objects.equals(this.objectId, other.objectId) && Objects.equals(this.catalogVersion, other.catalogVersion);
    }

    public String toString() {
        return "CatalogObjectReference [objectId=" + this.objectId + ", catalogVersion=" + this.catalogVersion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().objectId(this.getObjectId()).catalogVersion(this.getCatalogVersion());
        return builder;
    }

    public static class Builder {
        private String objectId;
        private Long catalogVersion;

        public Builder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public CatalogObjectReference build() {
            return new CatalogObjectReference(this.objectId, this.catalogVersion);
        }
    }
}

