/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.List;
import java.util.Objects;

public class CatalogPricingRule {
    private final String name;
    private final List<String> timePeriodIds;
    private final String discountId;
    private final String matchProductsId;
    private final String applyProductsId;
    private final String excludeProductsId;
    private final String validFromDate;
    private final String validFromLocalTime;
    private final String validUntilDate;
    private final String validUntilLocalTime;
    private final String excludeStrategy;
    private final Money minimumOrderSubtotalMoney;
    private final List<String> customerGroupIdsAny;

    @JsonCreator
    public CatalogPricingRule(@JsonProperty(value="name") String name, @JsonProperty(value="time_period_ids") List<String> timePeriodIds, @JsonProperty(value="discount_id") String discountId, @JsonProperty(value="match_products_id") String matchProductsId, @JsonProperty(value="apply_products_id") String applyProductsId, @JsonProperty(value="exclude_products_id") String excludeProductsId, @JsonProperty(value="valid_from_date") String validFromDate, @JsonProperty(value="valid_from_local_time") String validFromLocalTime, @JsonProperty(value="valid_until_date") String validUntilDate, @JsonProperty(value="valid_until_local_time") String validUntilLocalTime, @JsonProperty(value="exclude_strategy") String excludeStrategy, @JsonProperty(value="minimum_order_subtotal_money") Money minimumOrderSubtotalMoney, @JsonProperty(value="customer_group_ids_any") List<String> customerGroupIdsAny) {
        this.name = name;
        this.timePeriodIds = timePeriodIds;
        this.discountId = discountId;
        this.matchProductsId = matchProductsId;
        this.applyProductsId = applyProductsId;
        this.excludeProductsId = excludeProductsId;
        this.validFromDate = validFromDate;
        this.validFromLocalTime = validFromLocalTime;
        this.validUntilDate = validUntilDate;
        this.validUntilLocalTime = validUntilLocalTime;
        this.excludeStrategy = excludeStrategy;
        this.minimumOrderSubtotalMoney = minimumOrderSubtotalMoney;
        this.customerGroupIdsAny = customerGroupIdsAny;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="time_period_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getTimePeriodIds() {
        return this.timePeriodIds;
    }

    @JsonGetter(value="discount_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDiscountId() {
        return this.discountId;
    }

    @JsonGetter(value="match_products_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMatchProductsId() {
        return this.matchProductsId;
    }

    @JsonGetter(value="apply_products_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getApplyProductsId() {
        return this.applyProductsId;
    }

    @JsonGetter(value="exclude_products_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExcludeProductsId() {
        return this.excludeProductsId;
    }

    @JsonGetter(value="valid_from_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getValidFromDate() {
        return this.validFromDate;
    }

    @JsonGetter(value="valid_from_local_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getValidFromLocalTime() {
        return this.validFromLocalTime;
    }

    @JsonGetter(value="valid_until_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getValidUntilDate() {
        return this.validUntilDate;
    }

    @JsonGetter(value="valid_until_local_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getValidUntilLocalTime() {
        return this.validUntilLocalTime;
    }

    @JsonGetter(value="exclude_strategy")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExcludeStrategy() {
        return this.excludeStrategy;
    }

    @JsonGetter(value="minimum_order_subtotal_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getMinimumOrderSubtotalMoney() {
        return this.minimumOrderSubtotalMoney;
    }

    @JsonGetter(value="customer_group_ids_any")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getCustomerGroupIdsAny() {
        return this.customerGroupIdsAny;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.timePeriodIds, this.discountId, this.matchProductsId, this.applyProductsId, this.excludeProductsId, this.validFromDate, this.validFromLocalTime, this.validUntilDate, this.validUntilLocalTime, this.excludeStrategy, this.minimumOrderSubtotalMoney, this.customerGroupIdsAny);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogPricingRule)) {
            return false;
        }
        CatalogPricingRule other = (CatalogPricingRule)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.timePeriodIds, other.timePeriodIds) && Objects.equals(this.discountId, other.discountId) && Objects.equals(this.matchProductsId, other.matchProductsId) && Objects.equals(this.applyProductsId, other.applyProductsId) && Objects.equals(this.excludeProductsId, other.excludeProductsId) && Objects.equals(this.validFromDate, other.validFromDate) && Objects.equals(this.validFromLocalTime, other.validFromLocalTime) && Objects.equals(this.validUntilDate, other.validUntilDate) && Objects.equals(this.validUntilLocalTime, other.validUntilLocalTime) && Objects.equals(this.excludeStrategy, other.excludeStrategy) && Objects.equals(this.minimumOrderSubtotalMoney, other.minimumOrderSubtotalMoney) && Objects.equals(this.customerGroupIdsAny, other.customerGroupIdsAny);
    }

    public String toString() {
        return "CatalogPricingRule [name=" + this.name + ", timePeriodIds=" + this.timePeriodIds + ", discountId=" + this.discountId + ", matchProductsId=" + this.matchProductsId + ", applyProductsId=" + this.applyProductsId + ", excludeProductsId=" + this.excludeProductsId + ", validFromDate=" + this.validFromDate + ", validFromLocalTime=" + this.validFromLocalTime + ", validUntilDate=" + this.validUntilDate + ", validUntilLocalTime=" + this.validUntilLocalTime + ", excludeStrategy=" + this.excludeStrategy + ", minimumOrderSubtotalMoney=" + this.minimumOrderSubtotalMoney + ", customerGroupIdsAny=" + this.customerGroupIdsAny + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).timePeriodIds(this.getTimePeriodIds()).discountId(this.getDiscountId()).matchProductsId(this.getMatchProductsId()).applyProductsId(this.getApplyProductsId()).excludeProductsId(this.getExcludeProductsId()).validFromDate(this.getValidFromDate()).validFromLocalTime(this.getValidFromLocalTime()).validUntilDate(this.getValidUntilDate()).validUntilLocalTime(this.getValidUntilLocalTime()).excludeStrategy(this.getExcludeStrategy()).minimumOrderSubtotalMoney(this.getMinimumOrderSubtotalMoney()).customerGroupIdsAny(this.getCustomerGroupIdsAny());
        return builder;
    }

    public static class Builder {
        private String name;
        private List<String> timePeriodIds;
        private String discountId;
        private String matchProductsId;
        private String applyProductsId;
        private String excludeProductsId;
        private String validFromDate;
        private String validFromLocalTime;
        private String validUntilDate;
        private String validUntilLocalTime;
        private String excludeStrategy;
        private Money minimumOrderSubtotalMoney;
        private List<String> customerGroupIdsAny;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder timePeriodIds(List<String> timePeriodIds) {
            this.timePeriodIds = timePeriodIds;
            return this;
        }

        public Builder discountId(String discountId) {
            this.discountId = discountId;
            return this;
        }

        public Builder matchProductsId(String matchProductsId) {
            this.matchProductsId = matchProductsId;
            return this;
        }

        public Builder applyProductsId(String applyProductsId) {
            this.applyProductsId = applyProductsId;
            return this;
        }

        public Builder excludeProductsId(String excludeProductsId) {
            this.excludeProductsId = excludeProductsId;
            return this;
        }

        public Builder validFromDate(String validFromDate) {
            this.validFromDate = validFromDate;
            return this;
        }

        public Builder validFromLocalTime(String validFromLocalTime) {
            this.validFromLocalTime = validFromLocalTime;
            return this;
        }

        public Builder validUntilDate(String validUntilDate) {
            this.validUntilDate = validUntilDate;
            return this;
        }

        public Builder validUntilLocalTime(String validUntilLocalTime) {
            this.validUntilLocalTime = validUntilLocalTime;
            return this;
        }

        public Builder excludeStrategy(String excludeStrategy) {
            this.excludeStrategy = excludeStrategy;
            return this;
        }

        public Builder minimumOrderSubtotalMoney(Money minimumOrderSubtotalMoney) {
            this.minimumOrderSubtotalMoney = minimumOrderSubtotalMoney;
            return this;
        }

        public Builder customerGroupIdsAny(List<String> customerGroupIdsAny) {
            this.customerGroupIdsAny = customerGroupIdsAny;
            return this;
        }

        public CatalogPricingRule build() {
            return new CatalogPricingRule(this.name, this.timePeriodIds, this.discountId, this.matchProductsId, this.applyProductsId, this.excludeProductsId, this.validFromDate, this.validFromLocalTime, this.validUntilDate, this.validUntilLocalTime, this.excludeStrategy, this.minimumOrderSubtotalMoney, this.customerGroupIdsAny);
        }
    }
}

