/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class CatalogProductSet {
    private final String name;
    private final List<String> productIdsAny;
    private final List<String> productIdsAll;
    private final Long quantityExact;
    private final Long quantityMin;
    private final Long quantityMax;
    private final Boolean allProducts;

    @JsonCreator
    public CatalogProductSet(@JsonProperty(value="name") String name, @JsonProperty(value="product_ids_any") List<String> productIdsAny, @JsonProperty(value="product_ids_all") List<String> productIdsAll, @JsonProperty(value="quantity_exact") Long quantityExact, @JsonProperty(value="quantity_min") Long quantityMin, @JsonProperty(value="quantity_max") Long quantityMax, @JsonProperty(value="all_products") Boolean allProducts) {
        this.name = name;
        this.productIdsAny = productIdsAny;
        this.productIdsAll = productIdsAll;
        this.quantityExact = quantityExact;
        this.quantityMin = quantityMin;
        this.quantityMax = quantityMax;
        this.allProducts = allProducts;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="product_ids_any")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getProductIdsAny() {
        return this.productIdsAny;
    }

    @JsonGetter(value="product_ids_all")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getProductIdsAll() {
        return this.productIdsAll;
    }

    @JsonGetter(value="quantity_exact")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getQuantityExact() {
        return this.quantityExact;
    }

    @JsonGetter(value="quantity_min")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getQuantityMin() {
        return this.quantityMin;
    }

    @JsonGetter(value="quantity_max")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getQuantityMax() {
        return this.quantityMax;
    }

    @JsonGetter(value="all_products")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAllProducts() {
        return this.allProducts;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.productIdsAny, this.productIdsAll, this.quantityExact, this.quantityMin, this.quantityMax, this.allProducts);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogProductSet)) {
            return false;
        }
        CatalogProductSet other = (CatalogProductSet)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.productIdsAny, other.productIdsAny) && Objects.equals(this.productIdsAll, other.productIdsAll) && Objects.equals(this.quantityExact, other.quantityExact) && Objects.equals(this.quantityMin, other.quantityMin) && Objects.equals(this.quantityMax, other.quantityMax) && Objects.equals(this.allProducts, other.allProducts);
    }

    public String toString() {
        return "CatalogProductSet [name=" + this.name + ", productIdsAny=" + this.productIdsAny + ", productIdsAll=" + this.productIdsAll + ", quantityExact=" + this.quantityExact + ", quantityMin=" + this.quantityMin + ", quantityMax=" + this.quantityMax + ", allProducts=" + this.allProducts + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).productIdsAny(this.getProductIdsAny()).productIdsAll(this.getProductIdsAll()).quantityExact(this.getQuantityExact()).quantityMin(this.getQuantityMin()).quantityMax(this.getQuantityMax()).allProducts(this.getAllProducts());
        return builder;
    }

    public static class Builder {
        private String name;
        private List<String> productIdsAny;
        private List<String> productIdsAll;
        private Long quantityExact;
        private Long quantityMin;
        private Long quantityMax;
        private Boolean allProducts;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder productIdsAny(List<String> productIdsAny) {
            this.productIdsAny = productIdsAny;
            return this;
        }

        public Builder productIdsAll(List<String> productIdsAll) {
            this.productIdsAll = productIdsAll;
            return this;
        }

        public Builder quantityExact(Long quantityExact) {
            this.quantityExact = quantityExact;
            return this;
        }

        public Builder quantityMin(Long quantityMin) {
            this.quantityMin = quantityMin;
            return this;
        }

        public Builder quantityMax(Long quantityMax) {
            this.quantityMax = quantityMax;
            return this;
        }

        public Builder allProducts(Boolean allProducts) {
            this.allProducts = allProducts;
            return this;
        }

        public CatalogProductSet build() {
            return new CatalogProductSet(this.name, this.productIdsAny, this.productIdsAll, this.quantityExact, this.quantityMin, this.quantityMax, this.allProducts);
        }
    }
}

