/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CatalogQueryExact {
    private final String attributeName;
    private final String attributeValue;

    @JsonCreator
    public CatalogQueryExact(@JsonProperty(value="attribute_name") String attributeName, @JsonProperty(value="attribute_value") String attributeValue) {
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }

    @JsonGetter(value="attribute_name")
    public String getAttributeName() {
        return this.attributeName;
    }

    @JsonGetter(value="attribute_value")
    public String getAttributeValue() {
        return this.attributeValue;
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.attributeValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogQueryExact)) {
            return false;
        }
        CatalogQueryExact other = (CatalogQueryExact)obj;
        return Objects.equals(this.attributeName, other.attributeName) && Objects.equals(this.attributeValue, other.attributeValue);
    }

    public String toString() {
        return "CatalogQueryExact [attributeName=" + this.attributeName + ", attributeValue=" + this.attributeValue + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.attributeName, this.attributeValue);
        return builder;
    }

    public static class Builder {
        private String attributeName;
        private String attributeValue;

        public Builder(String attributeName, String attributeValue) {
            this.attributeName = attributeName;
            this.attributeValue = attributeValue;
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public CatalogQueryExact build() {
            return new CatalogQueryExact(this.attributeName, this.attributeValue);
        }
    }
}

