/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class CatalogQuerySet {
    private final String attributeName;
    private final List<String> attributeValues;

    @JsonCreator
    public CatalogQuerySet(@JsonProperty(value="attribute_name") String attributeName, @JsonProperty(value="attribute_values") List<String> attributeValues) {
        this.attributeName = attributeName;
        this.attributeValues = attributeValues;
    }

    @JsonGetter(value="attribute_name")
    public String getAttributeName() {
        return this.attributeName;
    }

    @JsonGetter(value="attribute_values")
    public List<String> getAttributeValues() {
        return this.attributeValues;
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.attributeValues);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogQuerySet)) {
            return false;
        }
        CatalogQuerySet other = (CatalogQuerySet)obj;
        return Objects.equals(this.attributeName, other.attributeName) && Objects.equals(this.attributeValues, other.attributeValues);
    }

    public String toString() {
        return "CatalogQuerySet [attributeName=" + this.attributeName + ", attributeValues=" + this.attributeValues + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.attributeName, this.attributeValues);
        return builder;
    }

    public static class Builder {
        private String attributeName;
        private List<String> attributeValues;

        public Builder(String attributeName, List<String> attributeValues) {
            this.attributeName = attributeName;
            this.attributeValues = attributeValues;
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public Builder attributeValues(List<String> attributeValues) {
            this.attributeValues = attributeValues;
            return this;
        }

        public CatalogQuerySet build() {
            return new CatalogQuerySet(this.attributeName, this.attributeValues);
        }
    }
}

