/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CatalogStockConversion {
    private final String stockableItemVariationId;
    private final String stockableQuantity;
    private final String nonstockableQuantity;

    @JsonCreator
    public CatalogStockConversion(@JsonProperty(value="stockable_item_variation_id") String stockableItemVariationId, @JsonProperty(value="stockable_quantity") String stockableQuantity, @JsonProperty(value="nonstockable_quantity") String nonstockableQuantity) {
        this.stockableItemVariationId = stockableItemVariationId;
        this.stockableQuantity = stockableQuantity;
        this.nonstockableQuantity = nonstockableQuantity;
    }

    @JsonGetter(value="stockable_item_variation_id")
    public String getStockableItemVariationId() {
        return this.stockableItemVariationId;
    }

    @JsonGetter(value="stockable_quantity")
    public String getStockableQuantity() {
        return this.stockableQuantity;
    }

    @JsonGetter(value="nonstockable_quantity")
    public String getNonstockableQuantity() {
        return this.nonstockableQuantity;
    }

    public int hashCode() {
        return Objects.hash(this.stockableItemVariationId, this.stockableQuantity, this.nonstockableQuantity);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogStockConversion)) {
            return false;
        }
        CatalogStockConversion other = (CatalogStockConversion)obj;
        return Objects.equals(this.stockableItemVariationId, other.stockableItemVariationId) && Objects.equals(this.stockableQuantity, other.stockableQuantity) && Objects.equals(this.nonstockableQuantity, other.nonstockableQuantity);
    }

    public String toString() {
        return "CatalogStockConversion [stockableItemVariationId=" + this.stockableItemVariationId + ", stockableQuantity=" + this.stockableQuantity + ", nonstockableQuantity=" + this.nonstockableQuantity + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.stockableItemVariationId, this.stockableQuantity, this.nonstockableQuantity);
        return builder;
    }

    public static class Builder {
        private String stockableItemVariationId;
        private String stockableQuantity;
        private String nonstockableQuantity;

        public Builder(String stockableItemVariationId, String stockableQuantity, String nonstockableQuantity) {
            this.stockableItemVariationId = stockableItemVariationId;
            this.stockableQuantity = stockableQuantity;
            this.nonstockableQuantity = nonstockableQuantity;
        }

        public Builder stockableItemVariationId(String stockableItemVariationId) {
            this.stockableItemVariationId = stockableItemVariationId;
            return this;
        }

        public Builder stockableQuantity(String stockableQuantity) {
            this.stockableQuantity = stockableQuantity;
            return this;
        }

        public Builder nonstockableQuantity(String nonstockableQuantity) {
            this.nonstockableQuantity = nonstockableQuantity;
            return this;
        }

        public CatalogStockConversion build() {
            return new CatalogStockConversion(this.stockableItemVariationId, this.stockableQuantity, this.nonstockableQuantity);
        }
    }
}

