/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.SubscriptionPhase;
import java.util.List;
import java.util.Objects;

public class CatalogSubscriptionPlan {
    private final String name;
    private final List<SubscriptionPhase> phases;

    @JsonCreator
    public CatalogSubscriptionPlan(@JsonProperty(value="name") String name, @JsonProperty(value="phases") List<SubscriptionPhase> phases) {
        this.name = name;
        this.phases = phases;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="phases")
    public List<SubscriptionPhase> getPhases() {
        return this.phases;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.phases);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogSubscriptionPlan)) {
            return false;
        }
        CatalogSubscriptionPlan other = (CatalogSubscriptionPlan)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.phases, other.phases);
    }

    public String toString() {
        return "CatalogSubscriptionPlan [name=" + this.name + ", phases=" + this.phases + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name, this.phases);
        return builder;
    }

    public static class Builder {
        private String name;
        private List<SubscriptionPhase> phases;

        public Builder(String name, List<SubscriptionPhase> phases) {
            this.name = name;
            this.phases = phases;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder phases(List<SubscriptionPhase> phases) {
            this.phases = phases;
            return this;
        }

        public CatalogSubscriptionPlan build() {
            return new CatalogSubscriptionPlan(this.name, this.phases);
        }
    }
}

