/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CatalogTax {
    private final String name;
    private final String calculationPhase;
    private final String inclusionType;
    private final String percentage;
    private final Boolean appliesToCustomAmounts;
    private final Boolean enabled;

    @JsonCreator
    public CatalogTax(@JsonProperty(value="name") String name, @JsonProperty(value="calculation_phase") String calculationPhase, @JsonProperty(value="inclusion_type") String inclusionType, @JsonProperty(value="percentage") String percentage, @JsonProperty(value="applies_to_custom_amounts") Boolean appliesToCustomAmounts, @JsonProperty(value="enabled") Boolean enabled) {
        this.name = name;
        this.calculationPhase = calculationPhase;
        this.inclusionType = inclusionType;
        this.percentage = percentage;
        this.appliesToCustomAmounts = appliesToCustomAmounts;
        this.enabled = enabled;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="calculation_phase")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCalculationPhase() {
        return this.calculationPhase;
    }

    @JsonGetter(value="inclusion_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInclusionType() {
        return this.inclusionType;
    }

    @JsonGetter(value="percentage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPercentage() {
        return this.percentage;
    }

    @JsonGetter(value="applies_to_custom_amounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAppliesToCustomAmounts() {
        return this.appliesToCustomAmounts;
    }

    @JsonGetter(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getEnabled() {
        return this.enabled;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.calculationPhase, this.inclusionType, this.percentage, this.appliesToCustomAmounts, this.enabled);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogTax)) {
            return false;
        }
        CatalogTax other = (CatalogTax)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.calculationPhase, other.calculationPhase) && Objects.equals(this.inclusionType, other.inclusionType) && Objects.equals(this.percentage, other.percentage) && Objects.equals(this.appliesToCustomAmounts, other.appliesToCustomAmounts) && Objects.equals(this.enabled, other.enabled);
    }

    public String toString() {
        return "CatalogTax [name=" + this.name + ", calculationPhase=" + this.calculationPhase + ", inclusionType=" + this.inclusionType + ", percentage=" + this.percentage + ", appliesToCustomAmounts=" + this.appliesToCustomAmounts + ", enabled=" + this.enabled + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).calculationPhase(this.getCalculationPhase()).inclusionType(this.getInclusionType()).percentage(this.getPercentage()).appliesToCustomAmounts(this.getAppliesToCustomAmounts()).enabled(this.getEnabled());
        return builder;
    }

    public static class Builder {
        private String name;
        private String calculationPhase;
        private String inclusionType;
        private String percentage;
        private Boolean appliesToCustomAmounts;
        private Boolean enabled;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder calculationPhase(String calculationPhase) {
            this.calculationPhase = calculationPhase;
            return this;
        }

        public Builder inclusionType(String inclusionType) {
            this.inclusionType = inclusionType;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = percentage;
            return this;
        }

        public Builder appliesToCustomAmounts(Boolean appliesToCustomAmounts) {
            this.appliesToCustomAmounts = appliesToCustomAmounts;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public CatalogTax build() {
            return new CatalogTax(this.name, this.calculationPhase, this.inclusionType, this.percentage, this.appliesToCustomAmounts, this.enabled);
        }
    }
}

