/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CatalogV1Id {
    private final String catalogV1Id;
    private final String locationId;

    @JsonCreator
    public CatalogV1Id(@JsonProperty(value="catalog_v1_id") String catalogV1Id, @JsonProperty(value="location_id") String locationId) {
        this.catalogV1Id = catalogV1Id;
        this.locationId = locationId;
    }

    @JsonGetter(value="catalog_v1_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCatalogV1Id() {
        return this.catalogV1Id;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    public int hashCode() {
        return Objects.hash(this.catalogV1Id, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogV1Id)) {
            return false;
        }
        CatalogV1Id other = (CatalogV1Id)obj;
        return Objects.equals(this.catalogV1Id, other.catalogV1Id) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "CatalogV1Id [catalogV1Id=" + this.catalogV1Id + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().catalogV1Id(this.getCatalogV1Id()).locationId(this.getLocationId());
        return builder;
    }

    public static class Builder {
        private String catalogV1Id;
        private String locationId;

        public Builder catalogV1Id(String catalogV1Id) {
            this.catalogV1Id = catalogV1Id;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public CatalogV1Id build() {
            return new CatalogV1Id(this.catalogV1Id, this.locationId);
        }
    }
}

