/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Address;
import com.squareup.square.models.ChargeRequestAdditionalRecipient;
import com.squareup.square.models.Money;
import java.util.List;
import java.util.Objects;

public class ChargeRequest {
    private final String idempotencyKey;
    private final Money amountMoney;
    private final String cardNonce;
    private final String customerCardId;
    private final Boolean delayCapture;
    private final String referenceId;
    private final String note;
    private final String customerId;
    private final Address billingAddress;
    private final Address shippingAddress;
    private final String buyerEmailAddress;
    private final String orderId;
    private final List<ChargeRequestAdditionalRecipient> additionalRecipients;
    private final String verificationToken;

    @JsonCreator
    public ChargeRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="card_nonce") String cardNonce, @JsonProperty(value="customer_card_id") String customerCardId, @JsonProperty(value="delay_capture") Boolean delayCapture, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="note") String note, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="billing_address") Address billingAddress, @JsonProperty(value="shipping_address") Address shippingAddress, @JsonProperty(value="buyer_email_address") String buyerEmailAddress, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="additional_recipients") List<ChargeRequestAdditionalRecipient> additionalRecipients, @JsonProperty(value="verification_token") String verificationToken) {
        this.idempotencyKey = idempotencyKey;
        this.amountMoney = amountMoney;
        this.cardNonce = cardNonce;
        this.customerCardId = customerCardId;
        this.delayCapture = delayCapture;
        this.referenceId = referenceId;
        this.note = note;
        this.customerId = customerId;
        this.billingAddress = billingAddress;
        this.shippingAddress = shippingAddress;
        this.buyerEmailAddress = buyerEmailAddress;
        this.orderId = orderId;
        this.additionalRecipients = additionalRecipients;
        this.verificationToken = verificationToken;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="card_nonce")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardNonce() {
        return this.cardNonce;
    }

    @JsonGetter(value="customer_card_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerCardId() {
        return this.customerCardId;
    }

    @JsonGetter(value="delay_capture")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getDelayCapture() {
        return this.delayCapture;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNote() {
        return this.note;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="billing_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonGetter(value="shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonGetter(value="buyer_email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBuyerEmailAddress() {
        return this.buyerEmailAddress;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="additional_recipients")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ChargeRequestAdditionalRecipient> getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    @JsonGetter(value="verification_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVerificationToken() {
        return this.verificationToken;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.amountMoney, this.cardNonce, this.customerCardId, this.delayCapture, this.referenceId, this.note, this.customerId, this.billingAddress, this.shippingAddress, this.buyerEmailAddress, this.orderId, this.additionalRecipients, this.verificationToken);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChargeRequest)) {
            return false;
        }
        ChargeRequest other = (ChargeRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.cardNonce, other.cardNonce) && Objects.equals(this.customerCardId, other.customerCardId) && Objects.equals(this.delayCapture, other.delayCapture) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.note, other.note) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.billingAddress, other.billingAddress) && Objects.equals(this.shippingAddress, other.shippingAddress) && Objects.equals(this.buyerEmailAddress, other.buyerEmailAddress) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.additionalRecipients, other.additionalRecipients) && Objects.equals(this.verificationToken, other.verificationToken);
    }

    public String toString() {
        return "ChargeRequest [idempotencyKey=" + this.idempotencyKey + ", amountMoney=" + this.amountMoney + ", cardNonce=" + this.cardNonce + ", customerCardId=" + this.customerCardId + ", delayCapture=" + this.delayCapture + ", referenceId=" + this.referenceId + ", note=" + this.note + ", customerId=" + this.customerId + ", billingAddress=" + this.billingAddress + ", shippingAddress=" + this.shippingAddress + ", buyerEmailAddress=" + this.buyerEmailAddress + ", orderId=" + this.orderId + ", additionalRecipients=" + this.additionalRecipients + ", verificationToken=" + this.verificationToken + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.amountMoney).cardNonce(this.getCardNonce()).customerCardId(this.getCustomerCardId()).delayCapture(this.getDelayCapture()).referenceId(this.getReferenceId()).note(this.getNote()).customerId(this.getCustomerId()).billingAddress(this.getBillingAddress()).shippingAddress(this.getShippingAddress()).buyerEmailAddress(this.getBuyerEmailAddress()).orderId(this.getOrderId()).additionalRecipients(this.getAdditionalRecipients()).verificationToken(this.getVerificationToken());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private Money amountMoney;
        private String cardNonce;
        private String customerCardId;
        private Boolean delayCapture;
        private String referenceId;
        private String note;
        private String customerId;
        private Address billingAddress;
        private Address shippingAddress;
        private String buyerEmailAddress;
        private String orderId;
        private List<ChargeRequestAdditionalRecipient> additionalRecipients;
        private String verificationToken;

        public Builder(String idempotencyKey, Money amountMoney) {
            this.idempotencyKey = idempotencyKey;
            this.amountMoney = amountMoney;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder cardNonce(String cardNonce) {
            this.cardNonce = cardNonce;
            return this;
        }

        public Builder customerCardId(String customerCardId) {
            this.customerCardId = customerCardId;
            return this;
        }

        public Builder delayCapture(Boolean delayCapture) {
            this.delayCapture = delayCapture;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder billingAddress(Address billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder buyerEmailAddress(String buyerEmailAddress) {
            this.buyerEmailAddress = buyerEmailAddress;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder additionalRecipients(List<ChargeRequestAdditionalRecipient> additionalRecipients) {
            this.additionalRecipients = additionalRecipients;
            return this;
        }

        public Builder verificationToken(String verificationToken) {
            this.verificationToken = verificationToken;
            return this;
        }

        public ChargeRequest build() {
            return new ChargeRequest(this.idempotencyKey, this.amountMoney, this.cardNonce, this.customerCardId, this.delayCapture, this.referenceId, this.note, this.customerId, this.billingAddress, this.shippingAddress, this.buyerEmailAddress, this.orderId, this.additionalRecipients, this.verificationToken);
        }
    }
}

