/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class ChargeRequestAdditionalRecipient {
    private final String locationId;
    private final String description;
    private final Money amountMoney;

    @JsonCreator
    public ChargeRequestAdditionalRecipient(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="description") String description, @JsonProperty(value="amount_money") Money amountMoney) {
        this.locationId = locationId;
        this.description = description;
        this.amountMoney = amountMoney;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.description, this.amountMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChargeRequestAdditionalRecipient)) {
            return false;
        }
        ChargeRequestAdditionalRecipient other = (ChargeRequestAdditionalRecipient)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.description, other.description) && Objects.equals(this.amountMoney, other.amountMoney);
    }

    public String toString() {
        return "ChargeRequestAdditionalRecipient [locationId=" + this.locationId + ", description=" + this.description + ", amountMoney=" + this.amountMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationId, this.description, this.amountMoney);
        return builder;
    }

    public static class Builder {
        private String locationId;
        private String description;
        private Money amountMoney;

        public Builder(String locationId, String description, Money amountMoney) {
            this.locationId = locationId;
            this.description = description;
            this.amountMoney = amountMoney;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public ChargeRequestAdditionalRecipient build() {
            return new ChargeRequestAdditionalRecipient(this.locationId, this.description, this.amountMoney);
        }
    }
}

