/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.AdditionalRecipient;
import com.squareup.square.models.Address;
import com.squareup.square.models.Order;
import java.util.List;
import java.util.Objects;

public class Checkout {
    private final String id;
    private final String checkoutPageUrl;
    private final Boolean askForShippingAddress;
    private final String merchantSupportEmail;
    private final String prePopulateBuyerEmail;
    private final Address prePopulateShippingAddress;
    private final String redirectUrl;
    private final Order order;
    private final String createdAt;
    private final List<AdditionalRecipient> additionalRecipients;

    @JsonCreator
    public Checkout(@JsonProperty(value="id") String id, @JsonProperty(value="checkout_page_url") String checkoutPageUrl, @JsonProperty(value="ask_for_shipping_address") Boolean askForShippingAddress, @JsonProperty(value="merchant_support_email") String merchantSupportEmail, @JsonProperty(value="pre_populate_buyer_email") String prePopulateBuyerEmail, @JsonProperty(value="pre_populate_shipping_address") Address prePopulateShippingAddress, @JsonProperty(value="redirect_url") String redirectUrl, @JsonProperty(value="order") Order order, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="additional_recipients") List<AdditionalRecipient> additionalRecipients) {
        this.id = id;
        this.checkoutPageUrl = checkoutPageUrl;
        this.askForShippingAddress = askForShippingAddress;
        this.merchantSupportEmail = merchantSupportEmail;
        this.prePopulateBuyerEmail = prePopulateBuyerEmail;
        this.prePopulateShippingAddress = prePopulateShippingAddress;
        this.redirectUrl = redirectUrl;
        this.order = order;
        this.createdAt = createdAt;
        this.additionalRecipients = additionalRecipients;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="checkout_page_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCheckoutPageUrl() {
        return this.checkoutPageUrl;
    }

    @JsonGetter(value="ask_for_shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAskForShippingAddress() {
        return this.askForShippingAddress;
    }

    @JsonGetter(value="merchant_support_email")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantSupportEmail() {
        return this.merchantSupportEmail;
    }

    @JsonGetter(value="pre_populate_buyer_email")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrePopulateBuyerEmail() {
        return this.prePopulateBuyerEmail;
    }

    @JsonGetter(value="pre_populate_shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getPrePopulateShippingAddress() {
        return this.prePopulateShippingAddress;
    }

    @JsonGetter(value="redirect_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonGetter(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Order getOrder() {
        return this.order;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="additional_recipients")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<AdditionalRecipient> getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.checkoutPageUrl, this.askForShippingAddress, this.merchantSupportEmail, this.prePopulateBuyerEmail, this.prePopulateShippingAddress, this.redirectUrl, this.order, this.createdAt, this.additionalRecipients);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Checkout)) {
            return false;
        }
        Checkout other = (Checkout)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.checkoutPageUrl, other.checkoutPageUrl) && Objects.equals(this.askForShippingAddress, other.askForShippingAddress) && Objects.equals(this.merchantSupportEmail, other.merchantSupportEmail) && Objects.equals(this.prePopulateBuyerEmail, other.prePopulateBuyerEmail) && Objects.equals(this.prePopulateShippingAddress, other.prePopulateShippingAddress) && Objects.equals(this.redirectUrl, other.redirectUrl) && Objects.equals(this.order, other.order) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.additionalRecipients, other.additionalRecipients);
    }

    public String toString() {
        return "Checkout [id=" + this.id + ", checkoutPageUrl=" + this.checkoutPageUrl + ", askForShippingAddress=" + this.askForShippingAddress + ", merchantSupportEmail=" + this.merchantSupportEmail + ", prePopulateBuyerEmail=" + this.prePopulateBuyerEmail + ", prePopulateShippingAddress=" + this.prePopulateShippingAddress + ", redirectUrl=" + this.redirectUrl + ", order=" + this.order + ", createdAt=" + this.createdAt + ", additionalRecipients=" + this.additionalRecipients + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).checkoutPageUrl(this.getCheckoutPageUrl()).askForShippingAddress(this.getAskForShippingAddress()).merchantSupportEmail(this.getMerchantSupportEmail()).prePopulateBuyerEmail(this.getPrePopulateBuyerEmail()).prePopulateShippingAddress(this.getPrePopulateShippingAddress()).redirectUrl(this.getRedirectUrl()).order(this.getOrder()).createdAt(this.getCreatedAt()).additionalRecipients(this.getAdditionalRecipients());
        return builder;
    }

    public static class Builder {
        private String id;
        private String checkoutPageUrl;
        private Boolean askForShippingAddress;
        private String merchantSupportEmail;
        private String prePopulateBuyerEmail;
        private Address prePopulateShippingAddress;
        private String redirectUrl;
        private Order order;
        private String createdAt;
        private List<AdditionalRecipient> additionalRecipients;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder checkoutPageUrl(String checkoutPageUrl) {
            this.checkoutPageUrl = checkoutPageUrl;
            return this;
        }

        public Builder askForShippingAddress(Boolean askForShippingAddress) {
            this.askForShippingAddress = askForShippingAddress;
            return this;
        }

        public Builder merchantSupportEmail(String merchantSupportEmail) {
            this.merchantSupportEmail = merchantSupportEmail;
            return this;
        }

        public Builder prePopulateBuyerEmail(String prePopulateBuyerEmail) {
            this.prePopulateBuyerEmail = prePopulateBuyerEmail;
            return this;
        }

        public Builder prePopulateShippingAddress(Address prePopulateShippingAddress) {
            this.prePopulateShippingAddress = prePopulateShippingAddress;
            return this;
        }

        public Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public Builder order(Order order) {
            this.order = order;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder additionalRecipients(List<AdditionalRecipient> additionalRecipients) {
            this.additionalRecipients = additionalRecipients;
            return this;
        }

        public Checkout build() {
            return new Checkout(this.id, this.checkoutPageUrl, this.askForShippingAddress, this.merchantSupportEmail, this.prePopulateBuyerEmail, this.prePopulateShippingAddress, this.redirectUrl, this.order, this.createdAt, this.additionalRecipients);
        }
    }
}

