/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.AcceptedPaymentMethods;
import com.squareup.square.models.CustomField;
import java.util.List;
import java.util.Objects;

public class CheckoutOptions {
    private final Boolean allowTipping;
    private final List<CustomField> customFields;
    private final String subscriptionPlanId;
    private final String redirectUrl;
    private final String merchantSupportEmail;
    private final Boolean askForShippingAddress;
    private final AcceptedPaymentMethods acceptedPaymentMethods;

    @JsonCreator
    public CheckoutOptions(@JsonProperty(value="allow_tipping") Boolean allowTipping, @JsonProperty(value="custom_fields") List<CustomField> customFields, @JsonProperty(value="subscription_plan_id") String subscriptionPlanId, @JsonProperty(value="redirect_url") String redirectUrl, @JsonProperty(value="merchant_support_email") String merchantSupportEmail, @JsonProperty(value="ask_for_shipping_address") Boolean askForShippingAddress, @JsonProperty(value="accepted_payment_methods") AcceptedPaymentMethods acceptedPaymentMethods) {
        this.allowTipping = allowTipping;
        this.customFields = customFields;
        this.subscriptionPlanId = subscriptionPlanId;
        this.redirectUrl = redirectUrl;
        this.merchantSupportEmail = merchantSupportEmail;
        this.askForShippingAddress = askForShippingAddress;
        this.acceptedPaymentMethods = acceptedPaymentMethods;
    }

    @JsonGetter(value="allow_tipping")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAllowTipping() {
        return this.allowTipping;
    }

    @JsonGetter(value="custom_fields")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CustomField> getCustomFields() {
        return this.customFields;
    }

    @JsonGetter(value="subscription_plan_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSubscriptionPlanId() {
        return this.subscriptionPlanId;
    }

    @JsonGetter(value="redirect_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonGetter(value="merchant_support_email")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantSupportEmail() {
        return this.merchantSupportEmail;
    }

    @JsonGetter(value="ask_for_shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAskForShippingAddress() {
        return this.askForShippingAddress;
    }

    @JsonGetter(value="accepted_payment_methods")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AcceptedPaymentMethods getAcceptedPaymentMethods() {
        return this.acceptedPaymentMethods;
    }

    public int hashCode() {
        return Objects.hash(this.allowTipping, this.customFields, this.subscriptionPlanId, this.redirectUrl, this.merchantSupportEmail, this.askForShippingAddress, this.acceptedPaymentMethods);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CheckoutOptions)) {
            return false;
        }
        CheckoutOptions other = (CheckoutOptions)obj;
        return Objects.equals(this.allowTipping, other.allowTipping) && Objects.equals(this.customFields, other.customFields) && Objects.equals(this.subscriptionPlanId, other.subscriptionPlanId) && Objects.equals(this.redirectUrl, other.redirectUrl) && Objects.equals(this.merchantSupportEmail, other.merchantSupportEmail) && Objects.equals(this.askForShippingAddress, other.askForShippingAddress) && Objects.equals(this.acceptedPaymentMethods, other.acceptedPaymentMethods);
    }

    public String toString() {
        return "CheckoutOptions [allowTipping=" + this.allowTipping + ", customFields=" + this.customFields + ", subscriptionPlanId=" + this.subscriptionPlanId + ", redirectUrl=" + this.redirectUrl + ", merchantSupportEmail=" + this.merchantSupportEmail + ", askForShippingAddress=" + this.askForShippingAddress + ", acceptedPaymentMethods=" + this.acceptedPaymentMethods + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().allowTipping(this.getAllowTipping()).customFields(this.getCustomFields()).subscriptionPlanId(this.getSubscriptionPlanId()).redirectUrl(this.getRedirectUrl()).merchantSupportEmail(this.getMerchantSupportEmail()).askForShippingAddress(this.getAskForShippingAddress()).acceptedPaymentMethods(this.getAcceptedPaymentMethods());
        return builder;
    }

    public static class Builder {
        private Boolean allowTipping;
        private List<CustomField> customFields;
        private String subscriptionPlanId;
        private String redirectUrl;
        private String merchantSupportEmail;
        private Boolean askForShippingAddress;
        private AcceptedPaymentMethods acceptedPaymentMethods;

        public Builder allowTipping(Boolean allowTipping) {
            this.allowTipping = allowTipping;
            return this;
        }

        public Builder customFields(List<CustomField> customFields) {
            this.customFields = customFields;
            return this;
        }

        public Builder subscriptionPlanId(String subscriptionPlanId) {
            this.subscriptionPlanId = subscriptionPlanId;
            return this;
        }

        public Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public Builder merchantSupportEmail(String merchantSupportEmail) {
            this.merchantSupportEmail = merchantSupportEmail;
            return this;
        }

        public Builder askForShippingAddress(Boolean askForShippingAddress) {
            this.askForShippingAddress = askForShippingAddress;
            return this;
        }

        public Builder acceptedPaymentMethods(AcceptedPaymentMethods acceptedPaymentMethods) {
            this.acceptedPaymentMethods = acceptedPaymentMethods;
            return this;
        }

        public CheckoutOptions build() {
            return new CheckoutOptions(this.allowTipping, this.customFields, this.subscriptionPlanId, this.redirectUrl, this.merchantSupportEmail, this.askForShippingAddress, this.acceptedPaymentMethods);
        }
    }
}

