/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CloneOrderRequest {
    private final String orderId;
    private final Integer version;
    private final String idempotencyKey;

    @JsonCreator
    public CloneOrderRequest(@JsonProperty(value="order_id") String orderId, @JsonProperty(value="version") Integer version, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.orderId = orderId;
        this.version = version;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.version, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CloneOrderRequest)) {
            return false;
        }
        CloneOrderRequest other = (CloneOrderRequest)obj;
        return Objects.equals(this.orderId, other.orderId) && Objects.equals(this.version, other.version) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "CloneOrderRequest [orderId=" + this.orderId + ", version=" + this.version + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.orderId).version(this.getVersion()).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private String orderId;
        private Integer version;
        private String idempotencyKey;

        public Builder(String orderId) {
            this.orderId = orderId;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CloneOrderRequest build() {
            return new CloneOrderRequest(this.orderId, this.version, this.idempotencyKey);
        }
    }
}

