/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Coordinates {
    private final Double latitude;
    private final Double longitude;

    @JsonCreator
    public Coordinates(@JsonProperty(value="latitude") Double latitude, @JsonProperty(value="longitude") Double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @JsonGetter(value="latitude")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getLatitude() {
        return this.latitude;
    }

    @JsonGetter(value="longitude")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getLongitude() {
        return this.longitude;
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Coordinates)) {
            return false;
        }
        Coordinates other = (Coordinates)obj;
        return Objects.equals(this.latitude, other.latitude) && Objects.equals(this.longitude, other.longitude);
    }

    public String toString() {
        return "Coordinates [latitude=" + this.latitude + ", longitude=" + this.longitude + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().latitude(this.getLatitude()).longitude(this.getLongitude());
        return builder;
    }

    public static class Builder {
        private Double latitude;
        private Double longitude;

        public Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Coordinates build() {
            return new Coordinates(this.latitude, this.longitude);
        }
    }
}

