/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Card;
import java.util.Objects;

public class CreateCardRequest {
    private final String idempotencyKey;
    private final String sourceId;
    private final String verificationToken;
    private final Card card;

    @JsonCreator
    public CreateCardRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="source_id") String sourceId, @JsonProperty(value="card") Card card, @JsonProperty(value="verification_token") String verificationToken) {
        this.idempotencyKey = idempotencyKey;
        this.sourceId = sourceId;
        this.verificationToken = verificationToken;
        this.card = card;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="source_id")
    public String getSourceId() {
        return this.sourceId;
    }

    @JsonGetter(value="verification_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVerificationToken() {
        return this.verificationToken;
    }

    @JsonGetter(value="card")
    public Card getCard() {
        return this.card;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.sourceId, this.verificationToken, this.card);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateCardRequest)) {
            return false;
        }
        CreateCardRequest other = (CreateCardRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.verificationToken, other.verificationToken) && Objects.equals(this.card, other.card);
    }

    public String toString() {
        return "CreateCardRequest [idempotencyKey=" + this.idempotencyKey + ", sourceId=" + this.sourceId + ", card=" + this.card + ", verificationToken=" + this.verificationToken + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.sourceId, this.card).verificationToken(this.getVerificationToken());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private String sourceId;
        private Card card;
        private String verificationToken;

        public Builder(String idempotencyKey, String sourceId, Card card) {
            this.idempotencyKey = idempotencyKey;
            this.sourceId = sourceId;
            this.card = card;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder card(Card card) {
            this.card = card;
            return this;
        }

        public Builder verificationToken(String verificationToken) {
            this.verificationToken = verificationToken;
            return this;
        }

        public CreateCardRequest build() {
            return new CreateCardRequest(this.idempotencyKey, this.sourceId, this.card, this.verificationToken);
        }
    }
}

