/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Card;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class CreateCardResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Card card;

    @JsonCreator
    public CreateCardResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="card") Card card) {
        this.errors = errors;
        this.card = card;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Card getCard() {
        return this.card;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.card);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateCardResponse)) {
            return false;
        }
        CreateCardResponse other = (CreateCardResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.card, other.card);
    }

    public String toString() {
        return "CreateCardResponse [errors=" + this.errors + ", card=" + this.card + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).card(this.getCard());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Card card;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder card(Card card) {
            this.card = card;
            return this;
        }

        public CreateCardResponse build() {
            CreateCardResponse model = new CreateCardResponse(this.errors, this.card);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

