/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogObject;
import java.util.Objects;

public class CreateCatalogImageRequest {
    private final String idempotencyKey;
    private final String objectId;
    private final CatalogObject image;
    private final Boolean isPrimary;

    @JsonCreator
    public CreateCatalogImageRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="image") CatalogObject image, @JsonProperty(value="object_id") String objectId, @JsonProperty(value="is_primary") Boolean isPrimary) {
        this.idempotencyKey = idempotencyKey;
        this.objectId = objectId;
        this.image = image;
        this.isPrimary = isPrimary;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getObjectId() {
        return this.objectId;
    }

    @JsonGetter(value="image")
    public CatalogObject getImage() {
        return this.image;
    }

    @JsonGetter(value="is_primary")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.objectId, this.image, this.isPrimary);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateCatalogImageRequest)) {
            return false;
        }
        CreateCatalogImageRequest other = (CreateCatalogImageRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.objectId, other.objectId) && Objects.equals(this.image, other.image) && Objects.equals(this.isPrimary, other.isPrimary);
    }

    public String toString() {
        return "CreateCatalogImageRequest [idempotencyKey=" + this.idempotencyKey + ", image=" + this.image + ", objectId=" + this.objectId + ", isPrimary=" + this.isPrimary + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.image).objectId(this.getObjectId()).isPrimary(this.getIsPrimary());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private CatalogObject image;
        private String objectId;
        private Boolean isPrimary;

        public Builder(String idempotencyKey, CatalogObject image) {
            this.idempotencyKey = idempotencyKey;
            this.image = image;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder image(CatalogObject image) {
            this.image = image;
            return this;
        }

        public Builder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public Builder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        public CreateCatalogImageRequest build() {
            return new CreateCatalogImageRequest(this.idempotencyKey, this.image, this.objectId, this.isPrimary);
        }
    }
}

