/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Address;
import java.util.Objects;

public class CreateCustomerCardRequest {
    private final String cardNonce;
    private final Address billingAddress;
    private final String cardholderName;
    private final String verificationToken;

    @JsonCreator
    public CreateCustomerCardRequest(@JsonProperty(value="card_nonce") String cardNonce, @JsonProperty(value="billing_address") Address billingAddress, @JsonProperty(value="cardholder_name") String cardholderName, @JsonProperty(value="verification_token") String verificationToken) {
        this.cardNonce = cardNonce;
        this.billingAddress = billingAddress;
        this.cardholderName = cardholderName;
        this.verificationToken = verificationToken;
    }

    @JsonGetter(value="card_nonce")
    public String getCardNonce() {
        return this.cardNonce;
    }

    @JsonGetter(value="billing_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonGetter(value="cardholder_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardholderName() {
        return this.cardholderName;
    }

    @JsonGetter(value="verification_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVerificationToken() {
        return this.verificationToken;
    }

    public int hashCode() {
        return Objects.hash(this.cardNonce, this.billingAddress, this.cardholderName, this.verificationToken);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateCustomerCardRequest)) {
            return false;
        }
        CreateCustomerCardRequest other = (CreateCustomerCardRequest)obj;
        return Objects.equals(this.cardNonce, other.cardNonce) && Objects.equals(this.billingAddress, other.billingAddress) && Objects.equals(this.cardholderName, other.cardholderName) && Objects.equals(this.verificationToken, other.verificationToken);
    }

    public String toString() {
        return "CreateCustomerCardRequest [cardNonce=" + this.cardNonce + ", billingAddress=" + this.billingAddress + ", cardholderName=" + this.cardholderName + ", verificationToken=" + this.verificationToken + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.cardNonce).billingAddress(this.getBillingAddress()).cardholderName(this.getCardholderName()).verificationToken(this.getVerificationToken());
        return builder;
    }

    public static class Builder {
        private String cardNonce;
        private Address billingAddress;
        private String cardholderName;
        private String verificationToken;

        public Builder(String cardNonce) {
            this.cardNonce = cardNonce;
        }

        public Builder cardNonce(String cardNonce) {
            this.cardNonce = cardNonce;
            return this;
        }

        public Builder billingAddress(Address billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder cardholderName(String cardholderName) {
            this.cardholderName = cardholderName;
            return this;
        }

        public Builder verificationToken(String verificationToken) {
            this.verificationToken = verificationToken;
            return this;
        }

        public CreateCustomerCardRequest build() {
            return new CreateCustomerCardRequest(this.cardNonce, this.billingAddress, this.cardholderName, this.verificationToken);
        }
    }
}

