/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CustomerGroup;
import java.util.Objects;

public class CreateCustomerGroupRequest {
    private final String idempotencyKey;
    private final CustomerGroup group;

    @JsonCreator
    public CreateCustomerGroupRequest(@JsonProperty(value="group") CustomerGroup group, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        this.group = group;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="group")
    public CustomerGroup getGroup() {
        return this.group;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.group);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateCustomerGroupRequest)) {
            return false;
        }
        CreateCustomerGroupRequest other = (CreateCustomerGroupRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.group, other.group);
    }

    public String toString() {
        return "CreateCustomerGroupRequest [group=" + this.group + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.group).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private CustomerGroup group;
        private String idempotencyKey;

        public Builder(CustomerGroup group) {
            this.group = group;
        }

        public Builder group(CustomerGroup group) {
            this.group = group;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateCustomerGroupRequest build() {
            return new CreateCustomerGroupRequest(this.group, this.idempotencyKey);
        }
    }
}

