/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.DeviceCode;
import java.util.Objects;

public class CreateDeviceCodeRequest {
    private final String idempotencyKey;
    private final DeviceCode deviceCode;

    @JsonCreator
    public CreateDeviceCodeRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="device_code") DeviceCode deviceCode) {
        this.idempotencyKey = idempotencyKey;
        this.deviceCode = deviceCode;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="device_code")
    public DeviceCode getDeviceCode() {
        return this.deviceCode;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.deviceCode);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateDeviceCodeRequest)) {
            return false;
        }
        CreateDeviceCodeRequest other = (CreateDeviceCodeRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.deviceCode, other.deviceCode);
    }

    public String toString() {
        return "CreateDeviceCodeRequest [idempotencyKey=" + this.idempotencyKey + ", deviceCode=" + this.deviceCode + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.deviceCode);
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private DeviceCode deviceCode;

        public Builder(String idempotencyKey, DeviceCode deviceCode) {
            this.idempotencyKey = idempotencyKey;
            this.deviceCode = deviceCode;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder deviceCode(DeviceCode deviceCode) {
            this.deviceCode = deviceCode;
            return this;
        }

        public CreateDeviceCodeRequest build() {
            return new CreateDeviceCodeRequest(this.idempotencyKey, this.deviceCode);
        }
    }
}

