/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.DeviceCode;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class CreateDeviceCodeResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final DeviceCode deviceCode;

    @JsonCreator
    public CreateDeviceCodeResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="device_code") DeviceCode deviceCode) {
        this.errors = errors;
        this.deviceCode = deviceCode;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="device_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DeviceCode getDeviceCode() {
        return this.deviceCode;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.deviceCode);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateDeviceCodeResponse)) {
            return false;
        }
        CreateDeviceCodeResponse other = (CreateDeviceCodeResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.deviceCode, other.deviceCode);
    }

    public String toString() {
        return "CreateDeviceCodeResponse [errors=" + this.errors + ", deviceCode=" + this.deviceCode + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).deviceCode(this.getDeviceCode());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private DeviceCode deviceCode;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder deviceCode(DeviceCode deviceCode) {
            this.deviceCode = deviceCode;
            return this;
        }

        public CreateDeviceCodeResponse build() {
            CreateDeviceCodeResponse model = new CreateDeviceCodeResponse(this.errors, this.deviceCode);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

