/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.LoyaltyAccount;
import java.util.Objects;

public class CreateLoyaltyAccountRequest {
    private final LoyaltyAccount loyaltyAccount;
    private final String idempotencyKey;

    @JsonCreator
    public CreateLoyaltyAccountRequest(@JsonProperty(value="loyalty_account") LoyaltyAccount loyaltyAccount, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.loyaltyAccount = loyaltyAccount;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="loyalty_account")
    public LoyaltyAccount getLoyaltyAccount() {
        return this.loyaltyAccount;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyAccount, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateLoyaltyAccountRequest)) {
            return false;
        }
        CreateLoyaltyAccountRequest other = (CreateLoyaltyAccountRequest)obj;
        return Objects.equals(this.loyaltyAccount, other.loyaltyAccount) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "CreateLoyaltyAccountRequest [loyaltyAccount=" + this.loyaltyAccount + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.loyaltyAccount, this.idempotencyKey);
        return builder;
    }

    public static class Builder {
        private LoyaltyAccount loyaltyAccount;
        private String idempotencyKey;

        public Builder(LoyaltyAccount loyaltyAccount, String idempotencyKey) {
            this.loyaltyAccount = loyaltyAccount;
            this.idempotencyKey = idempotencyKey;
        }

        public Builder loyaltyAccount(LoyaltyAccount loyaltyAccount) {
            this.loyaltyAccount = loyaltyAccount;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateLoyaltyAccountRequest build() {
            return new CreateLoyaltyAccountRequest(this.loyaltyAccount, this.idempotencyKey);
        }
    }
}

