/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Order;
import java.util.Objects;

public class CreateOrderRequest {
    private final Order order;
    private final String idempotencyKey;

    @JsonCreator
    public CreateOrderRequest(@JsonProperty(value="order") Order order, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.order = order;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Order getOrder() {
        return this.order;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public int hashCode() {
        return Objects.hash(this.order, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateOrderRequest)) {
            return false;
        }
        CreateOrderRequest other = (CreateOrderRequest)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "CreateOrderRequest [order=" + this.order + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().order(this.getOrder()).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private Order order;
        private String idempotencyKey;

        public Builder order(Order order) {
            this.order = order;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateOrderRequest build() {
            return new CreateOrderRequest(this.order, this.idempotencyKey);
        }
    }
}

