/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.PaymentLink;
import java.util.List;
import java.util.Objects;

public class CreatePaymentLinkResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final PaymentLink paymentLink;

    @JsonCreator
    public CreatePaymentLinkResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="payment_link") PaymentLink paymentLink) {
        this.errors = errors;
        this.paymentLink = paymentLink;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="payment_link")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaymentLink getPaymentLink() {
        return this.paymentLink;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.paymentLink);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreatePaymentLinkResponse)) {
            return false;
        }
        CreatePaymentLinkResponse other = (CreatePaymentLinkResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.paymentLink, other.paymentLink);
    }

    public String toString() {
        return "CreatePaymentLinkResponse [errors=" + this.errors + ", paymentLink=" + this.paymentLink + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).paymentLink(this.getPaymentLink());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private PaymentLink paymentLink;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder paymentLink(PaymentLink paymentLink) {
            this.paymentLink = paymentLink;
            return this;
        }

        public CreatePaymentLinkResponse build() {
            CreatePaymentLinkResponse model = new CreatePaymentLinkResponse(this.errors, this.paymentLink);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

