/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Address;
import com.squareup.square.models.CashPaymentDetails;
import com.squareup.square.models.ExternalPaymentDetails;
import com.squareup.square.models.Money;
import java.util.Objects;

public class CreatePaymentRequest {
    private final String sourceId;
    private final String idempotencyKey;
    private final Money amountMoney;
    private final Money tipMoney;
    private final Money appFeeMoney;
    private final String delayDuration;
    private final Boolean autocomplete;
    private final String orderId;
    private final String customerId;
    private final String locationId;
    private final String teamMemberId;
    private final String referenceId;
    private final String verificationToken;
    private final Boolean acceptPartialAuthorization;
    private final String buyerEmailAddress;
    private final Address billingAddress;
    private final Address shippingAddress;
    private final String note;
    private final String statementDescriptionIdentifier;
    private final CashPaymentDetails cashDetails;
    private final ExternalPaymentDetails externalDetails;

    @JsonCreator
    public CreatePaymentRequest(@JsonProperty(value="source_id") String sourceId, @JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="tip_money") Money tipMoney, @JsonProperty(value="app_fee_money") Money appFeeMoney, @JsonProperty(value="delay_duration") String delayDuration, @JsonProperty(value="autocomplete") Boolean autocomplete, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="team_member_id") String teamMemberId, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="verification_token") String verificationToken, @JsonProperty(value="accept_partial_authorization") Boolean acceptPartialAuthorization, @JsonProperty(value="buyer_email_address") String buyerEmailAddress, @JsonProperty(value="billing_address") Address billingAddress, @JsonProperty(value="shipping_address") Address shippingAddress, @JsonProperty(value="note") String note, @JsonProperty(value="statement_description_identifier") String statementDescriptionIdentifier, @JsonProperty(value="cash_details") CashPaymentDetails cashDetails, @JsonProperty(value="external_details") ExternalPaymentDetails externalDetails) {
        this.sourceId = sourceId;
        this.idempotencyKey = idempotencyKey;
        this.amountMoney = amountMoney;
        this.tipMoney = tipMoney;
        this.appFeeMoney = appFeeMoney;
        this.delayDuration = delayDuration;
        this.autocomplete = autocomplete;
        this.orderId = orderId;
        this.customerId = customerId;
        this.locationId = locationId;
        this.teamMemberId = teamMemberId;
        this.referenceId = referenceId;
        this.verificationToken = verificationToken;
        this.acceptPartialAuthorization = acceptPartialAuthorization;
        this.buyerEmailAddress = buyerEmailAddress;
        this.billingAddress = billingAddress;
        this.shippingAddress = shippingAddress;
        this.note = note;
        this.statementDescriptionIdentifier = statementDescriptionIdentifier;
        this.cashDetails = cashDetails;
        this.externalDetails = externalDetails;
    }

    @JsonGetter(value="source_id")
    public String getSourceId() {
        return this.sourceId;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="tip_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTipMoney() {
        return this.tipMoney;
    }

    @JsonGetter(value="app_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonGetter(value="delay_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDelayDuration() {
        return this.delayDuration;
    }

    @JsonGetter(value="autocomplete")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAutocomplete() {
        return this.autocomplete;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="verification_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVerificationToken() {
        return this.verificationToken;
    }

    @JsonGetter(value="accept_partial_authorization")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAcceptPartialAuthorization() {
        return this.acceptPartialAuthorization;
    }

    @JsonGetter(value="buyer_email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBuyerEmailAddress() {
        return this.buyerEmailAddress;
    }

    @JsonGetter(value="billing_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonGetter(value="shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNote() {
        return this.note;
    }

    @JsonGetter(value="statement_description_identifier")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatementDescriptionIdentifier() {
        return this.statementDescriptionIdentifier;
    }

    @JsonGetter(value="cash_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CashPaymentDetails getCashDetails() {
        return this.cashDetails;
    }

    @JsonGetter(value="external_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ExternalPaymentDetails getExternalDetails() {
        return this.externalDetails;
    }

    public int hashCode() {
        return Objects.hash(this.sourceId, this.idempotencyKey, this.amountMoney, this.tipMoney, this.appFeeMoney, this.delayDuration, this.autocomplete, this.orderId, this.customerId, this.locationId, this.teamMemberId, this.referenceId, this.verificationToken, this.acceptPartialAuthorization, this.buyerEmailAddress, this.billingAddress, this.shippingAddress, this.note, this.statementDescriptionIdentifier, this.cashDetails, this.externalDetails);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreatePaymentRequest)) {
            return false;
        }
        CreatePaymentRequest other = (CreatePaymentRequest)obj;
        return Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.tipMoney, other.tipMoney) && Objects.equals(this.appFeeMoney, other.appFeeMoney) && Objects.equals(this.delayDuration, other.delayDuration) && Objects.equals(this.autocomplete, other.autocomplete) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.teamMemberId, other.teamMemberId) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.verificationToken, other.verificationToken) && Objects.equals(this.acceptPartialAuthorization, other.acceptPartialAuthorization) && Objects.equals(this.buyerEmailAddress, other.buyerEmailAddress) && Objects.equals(this.billingAddress, other.billingAddress) && Objects.equals(this.shippingAddress, other.shippingAddress) && Objects.equals(this.note, other.note) && Objects.equals(this.statementDescriptionIdentifier, other.statementDescriptionIdentifier) && Objects.equals(this.cashDetails, other.cashDetails) && Objects.equals(this.externalDetails, other.externalDetails);
    }

    public String toString() {
        return "CreatePaymentRequest [sourceId=" + this.sourceId + ", idempotencyKey=" + this.idempotencyKey + ", amountMoney=" + this.amountMoney + ", tipMoney=" + this.tipMoney + ", appFeeMoney=" + this.appFeeMoney + ", delayDuration=" + this.delayDuration + ", autocomplete=" + this.autocomplete + ", orderId=" + this.orderId + ", customerId=" + this.customerId + ", locationId=" + this.locationId + ", teamMemberId=" + this.teamMemberId + ", referenceId=" + this.referenceId + ", verificationToken=" + this.verificationToken + ", acceptPartialAuthorization=" + this.acceptPartialAuthorization + ", buyerEmailAddress=" + this.buyerEmailAddress + ", billingAddress=" + this.billingAddress + ", shippingAddress=" + this.shippingAddress + ", note=" + this.note + ", statementDescriptionIdentifier=" + this.statementDescriptionIdentifier + ", cashDetails=" + this.cashDetails + ", externalDetails=" + this.externalDetails + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.sourceId, this.idempotencyKey, this.amountMoney).tipMoney(this.getTipMoney()).appFeeMoney(this.getAppFeeMoney()).delayDuration(this.getDelayDuration()).autocomplete(this.getAutocomplete()).orderId(this.getOrderId()).customerId(this.getCustomerId()).locationId(this.getLocationId()).teamMemberId(this.getTeamMemberId()).referenceId(this.getReferenceId()).verificationToken(this.getVerificationToken()).acceptPartialAuthorization(this.getAcceptPartialAuthorization()).buyerEmailAddress(this.getBuyerEmailAddress()).billingAddress(this.getBillingAddress()).shippingAddress(this.getShippingAddress()).note(this.getNote()).statementDescriptionIdentifier(this.getStatementDescriptionIdentifier()).cashDetails(this.getCashDetails()).externalDetails(this.getExternalDetails());
        return builder;
    }

    public static class Builder {
        private String sourceId;
        private String idempotencyKey;
        private Money amountMoney;
        private Money tipMoney;
        private Money appFeeMoney;
        private String delayDuration;
        private Boolean autocomplete;
        private String orderId;
        private String customerId;
        private String locationId;
        private String teamMemberId;
        private String referenceId;
        private String verificationToken;
        private Boolean acceptPartialAuthorization;
        private String buyerEmailAddress;
        private Address billingAddress;
        private Address shippingAddress;
        private String note;
        private String statementDescriptionIdentifier;
        private CashPaymentDetails cashDetails;
        private ExternalPaymentDetails externalDetails;

        public Builder(String sourceId, String idempotencyKey, Money amountMoney) {
            this.sourceId = sourceId;
            this.idempotencyKey = idempotencyKey;
            this.amountMoney = amountMoney;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder tipMoney(Money tipMoney) {
            this.tipMoney = tipMoney;
            return this;
        }

        public Builder appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        public Builder delayDuration(String delayDuration) {
            this.delayDuration = delayDuration;
            return this;
        }

        public Builder autocomplete(Boolean autocomplete) {
            this.autocomplete = autocomplete;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder verificationToken(String verificationToken) {
            this.verificationToken = verificationToken;
            return this;
        }

        public Builder acceptPartialAuthorization(Boolean acceptPartialAuthorization) {
            this.acceptPartialAuthorization = acceptPartialAuthorization;
            return this;
        }

        public Builder buyerEmailAddress(String buyerEmailAddress) {
            this.buyerEmailAddress = buyerEmailAddress;
            return this;
        }

        public Builder billingAddress(Address billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public Builder statementDescriptionIdentifier(String statementDescriptionIdentifier) {
            this.statementDescriptionIdentifier = statementDescriptionIdentifier;
            return this;
        }

        public Builder cashDetails(CashPaymentDetails cashDetails) {
            this.cashDetails = cashDetails;
            return this;
        }

        public Builder externalDetails(ExternalPaymentDetails externalDetails) {
            this.externalDetails = externalDetails;
            return this;
        }

        public CreatePaymentRequest build() {
            return new CreatePaymentRequest(this.sourceId, this.idempotencyKey, this.amountMoney, this.tipMoney, this.appFeeMoney, this.delayDuration, this.autocomplete, this.orderId, this.customerId, this.locationId, this.teamMemberId, this.referenceId, this.verificationToken, this.acceptPartialAuthorization, this.buyerEmailAddress, this.billingAddress, this.shippingAddress, this.note, this.statementDescriptionIdentifier, this.cashDetails, this.externalDetails);
        }
    }
}

