/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class CreateRefundRequest {
    private final String idempotencyKey;
    private final String tenderId;
    private final String reason;
    private final Money amountMoney;

    @JsonCreator
    public CreateRefundRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="tender_id") String tenderId, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="reason") String reason) {
        this.idempotencyKey = idempotencyKey;
        this.tenderId = tenderId;
        this.reason = reason;
        this.amountMoney = amountMoney;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="tender_id")
    public String getTenderId() {
        return this.tenderId;
    }

    @JsonGetter(value="reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReason() {
        return this.reason;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.tenderId, this.reason, this.amountMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateRefundRequest)) {
            return false;
        }
        CreateRefundRequest other = (CreateRefundRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.tenderId, other.tenderId) && Objects.equals(this.reason, other.reason) && Objects.equals(this.amountMoney, other.amountMoney);
    }

    public String toString() {
        return "CreateRefundRequest [idempotencyKey=" + this.idempotencyKey + ", tenderId=" + this.tenderId + ", amountMoney=" + this.amountMoney + ", reason=" + this.reason + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.tenderId, this.amountMoney).reason(this.getReason());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private String tenderId;
        private Money amountMoney;
        private String reason;

        public Builder(String idempotencyKey, String tenderId, Money amountMoney) {
            this.idempotencyKey = idempotencyKey;
            this.tenderId = tenderId;
            this.amountMoney = amountMoney;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder tenderId(String tenderId) {
            this.tenderId = tenderId;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public CreateRefundRequest build() {
            return new CreateRefundRequest(this.idempotencyKey, this.tenderId, this.amountMoney, this.reason);
        }
    }
}

