/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Shift;
import java.util.Objects;

public class CreateShiftRequest {
    private final String idempotencyKey;
    private final Shift shift;

    @JsonCreator
    public CreateShiftRequest(@JsonProperty(value="shift") Shift shift, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        this.shift = shift;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="shift")
    public Shift getShift() {
        return this.shift;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.shift);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateShiftRequest)) {
            return false;
        }
        CreateShiftRequest other = (CreateShiftRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.shift, other.shift);
    }

    public String toString() {
        return "CreateShiftRequest [shift=" + this.shift + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.shift).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private Shift shift;
        private String idempotencyKey;

        public Builder(Shift shift) {
            this.shift = shift;
        }

        public Builder shift(Shift shift) {
            this.shift = shift;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateShiftRequest build() {
            return new CreateShiftRequest(this.shift, this.idempotencyKey);
        }
    }
}

