/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.TerminalAction;
import java.util.Objects;

public class CreateTerminalActionRequest {
    private final String idempotencyKey;
    private final TerminalAction action;

    @JsonCreator
    public CreateTerminalActionRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="action") TerminalAction action) {
        this.idempotencyKey = idempotencyKey;
        this.action = action;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="action")
    public TerminalAction getAction() {
        return this.action;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.action);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateTerminalActionRequest)) {
            return false;
        }
        CreateTerminalActionRequest other = (CreateTerminalActionRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.action, other.action);
    }

    public String toString() {
        return "CreateTerminalActionRequest [idempotencyKey=" + this.idempotencyKey + ", action=" + this.action + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.action);
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private TerminalAction action;

        public Builder(String idempotencyKey, TerminalAction action) {
            this.idempotencyKey = idempotencyKey;
            this.action = action;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder action(TerminalAction action) {
            this.action = action;
            return this;
        }

        public CreateTerminalActionRequest build() {
            return new CreateTerminalActionRequest(this.idempotencyKey, this.action);
        }
    }
}

