/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.TerminalCheckout;
import java.util.Objects;

public class CreateTerminalCheckoutRequest {
    private final String idempotencyKey;
    private final TerminalCheckout checkout;

    @JsonCreator
    public CreateTerminalCheckoutRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="checkout") TerminalCheckout checkout) {
        this.idempotencyKey = idempotencyKey;
        this.checkout = checkout;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="checkout")
    public TerminalCheckout getCheckout() {
        return this.checkout;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.checkout);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateTerminalCheckoutRequest)) {
            return false;
        }
        CreateTerminalCheckoutRequest other = (CreateTerminalCheckoutRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.checkout, other.checkout);
    }

    public String toString() {
        return "CreateTerminalCheckoutRequest [idempotencyKey=" + this.idempotencyKey + ", checkout=" + this.checkout + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.checkout);
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private TerminalCheckout checkout;

        public Builder(String idempotencyKey, TerminalCheckout checkout) {
            this.idempotencyKey = idempotencyKey;
            this.checkout = checkout;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder checkout(TerminalCheckout checkout) {
            this.checkout = checkout;
            return this;
        }

        public CreateTerminalCheckoutRequest build() {
            return new CreateTerminalCheckoutRequest(this.idempotencyKey, this.checkout);
        }
    }
}

