/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Vendor;
import java.util.Objects;

public class CreateVendorRequest {
    private final String idempotencyKey;
    private final Vendor vendor;

    @JsonCreator
    public CreateVendorRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="vendor") Vendor vendor) {
        this.idempotencyKey = idempotencyKey;
        this.vendor = vendor;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="vendor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Vendor getVendor() {
        return this.vendor;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.vendor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateVendorRequest)) {
            return false;
        }
        CreateVendorRequest other = (CreateVendorRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.vendor, other.vendor);
    }

    public String toString() {
        return "CreateVendorRequest [idempotencyKey=" + this.idempotencyKey + ", vendor=" + this.vendor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey).vendor(this.getVendor());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private Vendor vendor;

        public Builder(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder vendor(Vendor vendor) {
            this.vendor = vendor;
            return this;
        }

        public CreateVendorRequest build() {
            return new CreateVendorRequest(this.idempotencyKey, this.vendor);
        }
    }
}

