/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.SourceApplication;
import com.squareup.square.utilities.JsonObject;
import java.util.Objects;

public class CustomAttributeDefinition {
    private final String key;
    private final JsonObject schema;
    private final String name;
    private final String description;
    private final SourceApplication sourceApplication;
    private final String visibility;
    private final Integer version;
    private final String updatedAt;
    private final String createdAt;

    @JsonCreator
    public CustomAttributeDefinition(@JsonProperty(value="key") String key, @JsonProperty(value="schema") JsonObject schema, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="source_application") SourceApplication sourceApplication, @JsonProperty(value="visibility") String visibility, @JsonProperty(value="version") Integer version, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="created_at") String createdAt) {
        this.key = key;
        this.schema = schema;
        this.name = name;
        this.description = description;
        this.sourceApplication = sourceApplication;
        this.visibility = visibility;
        this.version = version;
        this.updatedAt = updatedAt;
        this.createdAt = createdAt;
    }

    @JsonGetter(value="key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getKey() {
        return this.key;
    }

    @JsonGetter(value="schema")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JsonObject getSchema() {
        return this.schema;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="source_application")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SourceApplication getSourceApplication() {
        return this.sourceApplication;
    }

    @JsonGetter(value="visibility")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVisibility() {
        return this.visibility;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.schema, this.name, this.description, this.sourceApplication, this.visibility, this.version, this.updatedAt, this.createdAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomAttributeDefinition)) {
            return false;
        }
        CustomAttributeDefinition other = (CustomAttributeDefinition)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.schema, other.schema) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.sourceApplication, other.sourceApplication) && Objects.equals(this.visibility, other.visibility) && Objects.equals(this.version, other.version) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.createdAt, other.createdAt);
    }

    public String toString() {
        return "CustomAttributeDefinition [key=" + this.key + ", schema=" + this.schema + ", name=" + this.name + ", description=" + this.description + ", sourceApplication=" + this.sourceApplication + ", visibility=" + this.visibility + ", version=" + this.version + ", updatedAt=" + this.updatedAt + ", createdAt=" + this.createdAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().key(this.getKey()).schema(this.getSchema()).name(this.getName()).description(this.getDescription()).sourceApplication(this.getSourceApplication()).visibility(this.getVisibility()).version(this.getVersion()).updatedAt(this.getUpdatedAt()).createdAt(this.getCreatedAt());
        return builder;
    }

    public static class Builder {
        private String key;
        private JsonObject schema;
        private String name;
        private String description;
        private SourceApplication sourceApplication;
        private String visibility;
        private Integer version;
        private String updatedAt;
        private String createdAt;

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder schema(JsonObject schema) {
            this.schema = schema;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder sourceApplication(SourceApplication sourceApplication) {
            this.sourceApplication = sourceApplication;
            return this;
        }

        public Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public CustomAttributeDefinition build() {
            return new CustomAttributeDefinition(this.key, this.schema, this.name, this.description, this.sourceApplication, this.visibility, this.version, this.updatedAt, this.createdAt);
        }
    }
}

