/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Address;
import com.squareup.square.models.Card;
import com.squareup.square.models.CustomerPreferences;
import com.squareup.square.models.CustomerTaxIds;
import java.util.List;
import java.util.Objects;

public class Customer {
    private final String id;
    private final String createdAt;
    private final String updatedAt;
    private final List<Card> cards;
    private final String givenName;
    private final String familyName;
    private final String nickname;
    private final String companyName;
    private final String emailAddress;
    private final Address address;
    private final String phoneNumber;
    private final String birthday;
    private final String referenceId;
    private final String note;
    private final CustomerPreferences preferences;
    private final String creationSource;
    private final List<String> groupIds;
    private final List<String> segmentIds;
    private final Long version;
    private final CustomerTaxIds taxIds;

    @JsonCreator
    public Customer(@JsonProperty(value="id") String id, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="cards") List<Card> cards, @JsonProperty(value="given_name") String givenName, @JsonProperty(value="family_name") String familyName, @JsonProperty(value="nickname") String nickname, @JsonProperty(value="company_name") String companyName, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="address") Address address, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="birthday") String birthday, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="note") String note, @JsonProperty(value="preferences") CustomerPreferences preferences, @JsonProperty(value="creation_source") String creationSource, @JsonProperty(value="group_ids") List<String> groupIds, @JsonProperty(value="segment_ids") List<String> segmentIds, @JsonProperty(value="version") Long version, @JsonProperty(value="tax_ids") CustomerTaxIds taxIds) {
        this.id = id;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.cards = cards;
        this.givenName = givenName;
        this.familyName = familyName;
        this.nickname = nickname;
        this.companyName = companyName;
        this.emailAddress = emailAddress;
        this.address = address;
        this.phoneNumber = phoneNumber;
        this.birthday = birthday;
        this.referenceId = referenceId;
        this.note = note;
        this.preferences = preferences;
        this.creationSource = creationSource;
        this.groupIds = groupIds;
        this.segmentIds = segmentIds;
        this.version = version;
        this.taxIds = taxIds;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="cards")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Card> getCards() {
        return this.cards;
    }

    @JsonGetter(value="given_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getGivenName() {
        return this.givenName;
    }

    @JsonGetter(value="family_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFamilyName() {
        return this.familyName;
    }

    @JsonGetter(value="nickname")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNickname() {
        return this.nickname;
    }

    @JsonGetter(value="company_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCompanyName() {
        return this.companyName;
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonGetter(value="address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getAddress() {
        return this.address;
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonGetter(value="birthday")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBirthday() {
        return this.birthday;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNote() {
        return this.note;
    }

    @JsonGetter(value="preferences")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerPreferences getPreferences() {
        return this.preferences;
    }

    @JsonGetter(value="creation_source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreationSource() {
        return this.creationSource;
    }

    @JsonGetter(value="group_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    @JsonGetter(value="segment_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getSegmentIds() {
        return this.segmentIds;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getVersion() {
        return this.version;
    }

    @JsonGetter(value="tax_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerTaxIds getTaxIds() {
        return this.taxIds;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.updatedAt, this.cards, this.givenName, this.familyName, this.nickname, this.companyName, this.emailAddress, this.address, this.phoneNumber, this.birthday, this.referenceId, this.note, this.preferences, this.creationSource, this.groupIds, this.segmentIds, this.version, this.taxIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.cards, other.cards) && Objects.equals(this.givenName, other.givenName) && Objects.equals(this.familyName, other.familyName) && Objects.equals(this.nickname, other.nickname) && Objects.equals(this.companyName, other.companyName) && Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.address, other.address) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.birthday, other.birthday) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.note, other.note) && Objects.equals(this.preferences, other.preferences) && Objects.equals(this.creationSource, other.creationSource) && Objects.equals(this.groupIds, other.groupIds) && Objects.equals(this.segmentIds, other.segmentIds) && Objects.equals(this.version, other.version) && Objects.equals(this.taxIds, other.taxIds);
    }

    public String toString() {
        return "Customer [id=" + this.id + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", cards=" + this.cards + ", givenName=" + this.givenName + ", familyName=" + this.familyName + ", nickname=" + this.nickname + ", companyName=" + this.companyName + ", emailAddress=" + this.emailAddress + ", address=" + this.address + ", phoneNumber=" + this.phoneNumber + ", birthday=" + this.birthday + ", referenceId=" + this.referenceId + ", note=" + this.note + ", preferences=" + this.preferences + ", creationSource=" + this.creationSource + ", groupIds=" + this.groupIds + ", segmentIds=" + this.segmentIds + ", version=" + this.version + ", taxIds=" + this.taxIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).cards(this.getCards()).givenName(this.getGivenName()).familyName(this.getFamilyName()).nickname(this.getNickname()).companyName(this.getCompanyName()).emailAddress(this.getEmailAddress()).address(this.getAddress()).phoneNumber(this.getPhoneNumber()).birthday(this.getBirthday()).referenceId(this.getReferenceId()).note(this.getNote()).preferences(this.getPreferences()).creationSource(this.getCreationSource()).groupIds(this.getGroupIds()).segmentIds(this.getSegmentIds()).version(this.getVersion()).taxIds(this.getTaxIds());
        return builder;
    }

    public static class Builder {
        private String id;
        private String createdAt;
        private String updatedAt;
        private List<Card> cards;
        private String givenName;
        private String familyName;
        private String nickname;
        private String companyName;
        private String emailAddress;
        private Address address;
        private String phoneNumber;
        private String birthday;
        private String referenceId;
        private String note;
        private CustomerPreferences preferences;
        private String creationSource;
        private List<String> groupIds;
        private List<String> segmentIds;
        private Long version;
        private CustomerTaxIds taxIds;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder cards(List<Card> cards) {
            this.cards = cards;
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder nickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder birthday(String birthday) {
            this.birthday = birthday;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public Builder preferences(CustomerPreferences preferences) {
            this.preferences = preferences;
            return this;
        }

        public Builder creationSource(String creationSource) {
            this.creationSource = creationSource;
            return this;
        }

        public Builder groupIds(List<String> groupIds) {
            this.groupIds = groupIds;
            return this;
        }

        public Builder segmentIds(List<String> segmentIds) {
            this.segmentIds = segmentIds;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder taxIds(CustomerTaxIds taxIds) {
            this.taxIds = taxIds;
            return this;
        }

        public Customer build() {
            return new Customer(this.id, this.createdAt, this.updatedAt, this.cards, this.givenName, this.familyName, this.nickname, this.companyName, this.emailAddress, this.address, this.phoneNumber, this.birthday, this.referenceId, this.note, this.preferences, this.creationSource, this.groupIds, this.segmentIds, this.version, this.taxIds);
        }
    }
}

