/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class CustomerCreationSourceFilter {
    private final List<String> values;
    private final String rule;

    @JsonCreator
    public CustomerCreationSourceFilter(@JsonProperty(value="values") List<String> values, @JsonProperty(value="rule") String rule) {
        this.values = values;
        this.rule = rule;
    }

    @JsonGetter(value="values")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getValues() {
        return this.values;
    }

    @JsonGetter(value="rule")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRule() {
        return this.rule;
    }

    public int hashCode() {
        return Objects.hash(this.values, this.rule);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerCreationSourceFilter)) {
            return false;
        }
        CustomerCreationSourceFilter other = (CustomerCreationSourceFilter)obj;
        return Objects.equals(this.values, other.values) && Objects.equals(this.rule, other.rule);
    }

    public String toString() {
        return "CustomerCreationSourceFilter [values=" + this.values + ", rule=" + this.rule + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().values(this.getValues()).rule(this.getRule());
        return builder;
    }

    public static class Builder {
        private List<String> values;
        private String rule;

        public Builder values(List<String> values) {
            this.values = values;
            return this;
        }

        public Builder rule(String rule) {
            this.rule = rule;
            return this;
        }

        public CustomerCreationSourceFilter build() {
            return new CustomerCreationSourceFilter(this.values, this.rule);
        }
    }
}

