/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CustomerFilter;
import com.squareup.square.models.CustomerSort;
import java.util.Objects;

public class CustomerQuery {
    private final CustomerFilter filter;
    private final CustomerSort sort;

    @JsonCreator
    public CustomerQuery(@JsonProperty(value="filter") CustomerFilter filter, @JsonProperty(value="sort") CustomerSort sort) {
        this.filter = filter;
        this.sort = sort;
    }

    @JsonGetter(value="filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerFilter getFilter() {
        return this.filter;
    }

    @JsonGetter(value="sort")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerSort getSort() {
        return this.sort;
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerQuery)) {
            return false;
        }
        CustomerQuery other = (CustomerQuery)obj;
        return Objects.equals(this.filter, other.filter) && Objects.equals(this.sort, other.sort);
    }

    public String toString() {
        return "CustomerQuery [filter=" + this.filter + ", sort=" + this.sort + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().filter(this.getFilter()).sort(this.getSort());
        return builder;
    }

    public static class Builder {
        private CustomerFilter filter;
        private CustomerSort sort;

        public Builder filter(CustomerFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder sort(CustomerSort sort) {
            this.sort = sort;
            return this;
        }

        public CustomerQuery build() {
            return new CustomerQuery(this.filter, this.sort);
        }
    }
}

