/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CustomerSort {
    private final String field;
    private final String order;

    @JsonCreator
    public CustomerSort(@JsonProperty(value="field") String field, @JsonProperty(value="order") String order) {
        this.field = field;
        this.order = order;
    }

    @JsonGetter(value="field")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getField() {
        return this.field;
    }

    @JsonGetter(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrder() {
        return this.order;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.order);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerSort)) {
            return false;
        }
        CustomerSort other = (CustomerSort)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.order, other.order);
    }

    public String toString() {
        return "CustomerSort [field=" + this.field + ", order=" + this.order + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().field(this.getField()).order(this.getOrder());
        return builder;
    }

    public static class Builder {
        private String field;
        private String order;

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Builder order(String order) {
            this.order = order;
            return this;
        }

        public CustomerSort build() {
            return new CustomerSort(this.field, this.order);
        }
    }
}

