/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CustomerTextFilter {
    private final String exact;
    private final String fuzzy;

    @JsonCreator
    public CustomerTextFilter(@JsonProperty(value="exact") String exact, @JsonProperty(value="fuzzy") String fuzzy) {
        this.exact = exact;
        this.fuzzy = fuzzy;
    }

    @JsonGetter(value="exact")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExact() {
        return this.exact;
    }

    @JsonGetter(value="fuzzy")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFuzzy() {
        return this.fuzzy;
    }

    public int hashCode() {
        return Objects.hash(this.exact, this.fuzzy);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerTextFilter)) {
            return false;
        }
        CustomerTextFilter other = (CustomerTextFilter)obj;
        return Objects.equals(this.exact, other.exact) && Objects.equals(this.fuzzy, other.fuzzy);
    }

    public String toString() {
        return "CustomerTextFilter [exact=" + this.exact + ", fuzzy=" + this.fuzzy + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().exact(this.getExact()).fuzzy(this.getFuzzy());
        return builder;
    }

    public static class Builder {
        private String exact;
        private String fuzzy;

        public Builder exact(String exact) {
            this.exact = exact;
            return this;
        }

        public Builder fuzzy(String fuzzy) {
            this.fuzzy = fuzzy;
            return this;
        }

        public CustomerTextFilter build() {
            return new CustomerTextFilter(this.exact, this.fuzzy);
        }
    }
}

