/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class DateRange {
    private final String startDate;
    private final String endDate;

    @JsonCreator
    public DateRange(@JsonProperty(value="start_date") String startDate, @JsonProperty(value="end_date") String endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    @JsonGetter(value="start_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStartDate() {
        return this.startDate;
    }

    @JsonGetter(value="end_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndDate() {
        return this.endDate;
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DateRange)) {
            return false;
        }
        DateRange other = (DateRange)obj;
        return Objects.equals(this.startDate, other.startDate) && Objects.equals(this.endDate, other.endDate);
    }

    public String toString() {
        return "DateRange [startDate=" + this.startDate + ", endDate=" + this.endDate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().startDate(this.getStartDate()).endDate(this.getEndDate());
        return builder;
    }

    public static class Builder {
        private String startDate;
        private String endDate;

        public Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public DateRange build() {
            return new DateRange(this.startDate, this.endDate);
        }
    }
}

