/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class DeletePaymentLinkResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final String id;
    private final String cancelledOrderId;

    @JsonCreator
    public DeletePaymentLinkResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="id") String id, @JsonProperty(value="cancelled_order_id") String cancelledOrderId) {
        this.errors = errors;
        this.id = id;
        this.cancelledOrderId = cancelledOrderId;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="cancelled_order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCancelledOrderId() {
        return this.cancelledOrderId;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.id, this.cancelledOrderId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeletePaymentLinkResponse)) {
            return false;
        }
        DeletePaymentLinkResponse other = (DeletePaymentLinkResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.id, other.id) && Objects.equals(this.cancelledOrderId, other.cancelledOrderId);
    }

    public String toString() {
        return "DeletePaymentLinkResponse [errors=" + this.errors + ", id=" + this.id + ", cancelledOrderId=" + this.cancelledOrderId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).id(this.getId()).cancelledOrderId(this.getCancelledOrderId());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private String id;
        private String cancelledOrderId;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder cancelledOrderId(String cancelledOrderId) {
            this.cancelledOrderId = cancelledOrderId;
            return this;
        }

        public DeletePaymentLinkResponse build() {
            DeletePaymentLinkResponse model = new DeletePaymentLinkResponse(this.errors, this.id, this.cancelledOrderId);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

