/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Destination {
    private final String type;
    private final String id;

    @JsonCreator
    public Destination(@JsonProperty(value="type") String type, @JsonProperty(value="id") String id) {
        this.type = type;
        this.id = id;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "Destination [type=" + this.type + ", id=" + this.id + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().type(this.getType()).id(this.getId());
        return builder;
    }

    public static class Builder {
        private String type;
        private String id;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Destination build() {
            return new Destination(this.type, this.id);
        }
    }
}

