/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class DeviceCode {
    private final String id;
    private final String name;
    private final String code;
    private final String deviceId;
    private final String productType;
    private final String locationId;
    private final String status;
    private final String pairBy;
    private final String createdAt;
    private final String statusChangedAt;
    private final String pairedAt;

    @JsonCreator
    public DeviceCode(@JsonProperty(value="product_type") String productType, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="code") String code, @JsonProperty(value="device_id") String deviceId, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="status") String status, @JsonProperty(value="pair_by") String pairBy, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="status_changed_at") String statusChangedAt, @JsonProperty(value="paired_at") String pairedAt) {
        this.id = id;
        this.name = name;
        this.code = code;
        this.deviceId = deviceId;
        this.productType = productType;
        this.locationId = locationId;
        this.status = status;
        this.pairBy = pairBy;
        this.createdAt = createdAt;
        this.statusChangedAt = statusChangedAt;
        this.pairedAt = pairedAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCode() {
        return this.code;
    }

    @JsonGetter(value="device_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonGetter(value="product_type")
    public String getProductType() {
        return this.productType;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="pair_by")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPairBy() {
        return this.pairBy;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="status_changed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatusChangedAt() {
        return this.statusChangedAt;
    }

    @JsonGetter(value="paired_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPairedAt() {
        return this.pairedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.code, this.deviceId, this.productType, this.locationId, this.status, this.pairBy, this.createdAt, this.statusChangedAt, this.pairedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeviceCode)) {
            return false;
        }
        DeviceCode other = (DeviceCode)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.code, other.code) && Objects.equals(this.deviceId, other.deviceId) && Objects.equals(this.productType, other.productType) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.status, other.status) && Objects.equals(this.pairBy, other.pairBy) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.statusChangedAt, other.statusChangedAt) && Objects.equals(this.pairedAt, other.pairedAt);
    }

    public String toString() {
        return "DeviceCode [productType=" + this.productType + ", id=" + this.id + ", name=" + this.name + ", code=" + this.code + ", deviceId=" + this.deviceId + ", locationId=" + this.locationId + ", status=" + this.status + ", pairBy=" + this.pairBy + ", createdAt=" + this.createdAt + ", statusChangedAt=" + this.statusChangedAt + ", pairedAt=" + this.pairedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.productType).id(this.getId()).name(this.getName()).code(this.getCode()).deviceId(this.getDeviceId()).locationId(this.getLocationId()).status(this.getStatus()).pairBy(this.getPairBy()).createdAt(this.getCreatedAt()).statusChangedAt(this.getStatusChangedAt()).pairedAt(this.getPairedAt());
        return builder;
    }

    public static class Builder {
        private String productType = "TERMINAL_API";
        private String id;
        private String name;
        private String code;
        private String deviceId;
        private String locationId;
        private String status;
        private String pairBy;
        private String createdAt;
        private String statusChangedAt;
        private String pairedAt;

        public Builder(String productType) {
            this.productType = productType;
        }

        public Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder pairBy(String pairBy) {
            this.pairBy = pairBy;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder statusChangedAt(String statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
            return this;
        }

        public Builder pairedAt(String pairedAt) {
            this.pairedAt = pairedAt;
            return this;
        }

        public DeviceCode build() {
            return new DeviceCode(this.productType, this.id, this.name, this.code, this.deviceId, this.locationId, this.status, this.pairBy, this.createdAt, this.statusChangedAt, this.pairedAt);
        }
    }
}

